<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_page')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.pages')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/pages')); ?>"><?php echo e(trans('home.pages')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_page')); ?></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    <?php echo Form::open(['method'=>'PATCH','url' => 'admin/pages/'.$page->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_page')); ?></h6>
                            <hr>
                        </div>
                        <div class="row">

                            <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.title_en')); ?></label>
                                    <input class="form-control" name="title_en" type="text" placeholder="<?php echo e(trans('home.title_en')); ?>" value="<?php echo e($page->title_en); ?>" required>
                                </div>

                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.title_ar')); ?></label>
                                    <input class="form-control" name="title_ar" type="text" placeholder="<?php echo e(trans('home.title_ar')); ?>" value="<?php echo e($page->title_ar); ?>">
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="text_en"> <?php echo e(trans('home.text_en')); ?></label>
                                    <textarea class="area1" name="text_en"><?php echo $page->text_en; ?></textarea>
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="text_ar"> <?php echo e(trans('home.text_ar')); ?></label>
                                    <textarea class="area1" name="text_ar"><?php echo $page->text_ar; ?></textarea>
                                </div>


                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="status" value="1" <?php echo e(($page->status == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                    </label>
                                </div>
                            </div>
                        </row>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->



        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.seo_block')); ?></h6>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="row">
                                    <div class="form-group col-md-12">
                                        <hr>
                                        <span class="badge badge-success"><?php echo e(trans('home.en')); ?></span>
                                    </div>






                                    <div class="form-group col-md-5">
                                        <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                        <textarea class="form-control" name="meta_title_en" placeholder="<?php echo e(trans('home.meta_title')); ?>"><?php echo e($page->meta_title_en); ?></textarea>
                                    </div>

                                    <div class="form-group col-md-5">
                                        <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                        <textarea class="form-control" name="meta_desc_en" placeholder="<?php echo e(trans('home.meta_desc')); ?>"><?php echo e($page->meta_desc_en); ?></textarea>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <hr>
                                        <span class="badge badge-success"><?php echo e(trans('home.ar')); ?></span>
                                    </div>






                                    <div class="form-group col-md-5">
                                        <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                        <textarea class="form-control" name="meta_title_ar" placeholder="<?php echo e(trans('home.meta_title')); ?>"><?php echo e($page->meta_title_ar); ?></textarea>
                                    </div>

                                    <div class="form-group col-md-5">
                                        <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                        <textarea class="form-control" name="meta_desc_ar" placeholder="<?php echo e(trans('home.meta_desc')); ?>"><?php echo e($page->meta_desc_ar); ?></textarea>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <label class="ckbox">
                                            <input name="meta_robots" value="1" <?php echo e(($page->meta_robots == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.meta_robots')); ?> (index)</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                <a href="<?php echo e(url('/admin/pages')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

    <?php echo Form::close(); ?>

    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\Almashreq\resources\views/admin/pages/editPage.blade.php ENDPATH**/ ?>