<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_service')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
<style>
    img {
        display:block !important;
    }
    .dz-hidden-input{
        position: absolute !important;
        top: 0px !important;
        left: 250px !important;
    }

</style>
<link href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/min/dropzone.min.css" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.edit_service')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/services')); ?>"><?php echo e(trans('home.services')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('home.edit_service')); ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <?php if(session()->has('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session()->pull('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    <div id="successmesg"  style="display: none; margin-bottom: 10px;"  class="alert alert-danger alert-dismissible fade show" role="alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
      </div>
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title "><?php echo e(trans('home.edit_service')); ?></h6>
                        </div>
                        <?php echo Form::open(['method'=>'PATCH','url' => 'admin/services/'.$service->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                            <div class="row">

                                <div class="col-md-4 mb-3">
                                    <label for="name_en"><?php echo e(trans('home.name_en')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.name_en')); ?>" name="name_en" value="<?php echo e($service->name_en); ?>" required>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label for="name_ar"><?php echo e(trans('home.name_ar')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.name_ar')); ?>" name="name_ar" value="<?php echo e($service->name_ar); ?>">
                                </div>

                                <div class="form-group col-md-3">
                                    <label for="helperText"><?php echo e(trans('home.parent')); ?></label>
                                    <select class="form-control"  data-trigger name="parent_id" required>
                                        <option value="0" <?php echo e(($service->parent_id == 0)?'selected':''); ?>><?php echo e(trans('home.no_parent')); ?></option>
                                        <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($serv->id); ?>"  <?php echo e(($serv->id ==$service->parent_id)?'selected':''); ?>><?php echo e((app()->getLocale() == 'en')?$serv->name_en:$serv->name_ar); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label for="youtube_link"><?php echo e(trans('home.youtube_link')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.youtube_link')); ?>" name="youtube_link" value="<?php echo e($service->youtube_link); ?>">
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label for="order"><?php echo e(trans('home.order')); ?></label>
                                    <input type="number" min="0"  class="form-control" placeholder="<?php echo e(trans('home.order')); ?>" name="order" value="<?php echo e($service->order); ?>">
                                </div>

                                <div class="col-md-6 mb-3 mt-3">
                                    <label for="formFile" class="form-label"><?php echo e(trans('home.choose_image')); ?></label>
                                    <input class="form-control" type="file" id="formFile" name="img">
                                </div>

                                <div class="col-md-2 mb-3 mt-3">
                                    <label ><?php echo e(trans('home.alt_img')); ?></label>
                                    <input class="form-control" name="alt_img" type="text" placeholder="<?php echo e(trans('home.alt_img')); ?>" value="<?php echo e($service->alt_img); ?>"/>
                                </div>

                                <?php if($service->img): ?>
                                    <div class=" col-md-2 m-2 mt-3">
                                        <img src="<?php echo e(url('\uploads\services\source')); ?>\<?php echo e($service->img); ?>" width="200" height="150">
                                    </div>
                                <?php else: ?>
                                    <div class=" col-md-3 mt-3">
                                        <img src="<?php echo e(url('resources/assets/back/images/noimage.jpg')); ?>" width="70">
                                    </div>
                                <?php endif; ?>

                                <div class="col-md-8 mb-3 mt-3">
                                    <label for="formFile" class="form-label"><?php echo e(trans('home.icon')); ?></label>
                                    <input class="form-control" type="file" id="formFile" name="icon">
                                </div>

                                <?php if($service->icon): ?>
                                    <div class="form-group  col-md-2 m-2 mt-3">
                                        <img src="<?php echo e(url('\uploads\services\source')); ?>\<?php echo e($service->icon); ?>" width="200" height="150">
                                    </div>
                                <?php else: ?>
                                    <div class="form-group  col-md-3 mt-3">
                                        <img src="<?php echo e(url('resources/assets/back/images/noimage.jpg')); ?>" width="70">
                                    </div>
                                <?php endif; ?>


                                <div class="form-group col-md-6">
                                    <label for="text_en"><?php echo e(trans('home.text_en')); ?></label>
                                    <textarea class="form-control ckeditor-classic" name="text_en" placeholder="<?php echo e(trans('home.text_en')); ?>" ><?php echo $service->text_en; ?></textarea>
                                </div>

                                <div class="form-group col-md-6 ">
                                    <label for="text_ar"><?php echo e(trans('home.text_ar')); ?></label>
                                    <textarea class="form-control ckeditor-classic" name="text_ar" placeholder="<?php echo e(trans('home.text_ar')); ?>" ><?php echo $service->text_ar; ?></textarea>
                                </div>

                                <div class="form-group col-md-12">
                                    <hr>
                                    <label for="images"><?php echo e(trans('home.service_images')); ?></label>
                                        <div class="dropzone col-md-12 upload_images">
                                    </div>
                                </div>
                                <?php if(count($service->images())>0): ?>
                                    <a href='#' data-id="<?php echo e($service->id); ?>" class='delete_all_img btn btn-danger mt-2 col-4' ><?php echo e(trans('home.delete_all')); ?></a>

                                    <div class="col-md-12 mt-3">
                                        <div id="" class="row mb-0">
                                            <?php $__currentLoopData = $service->images(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-xs-6 col-sm-2 col-md-2 col-xl-2 mb-2 pl-sm-2 pr-sm-2" data-responsive="<?php echo e(url('uploads/services/source/'.$image->image)); ?>"
                                                    data-src="<?php echo e(url('uploads/services/source/'.$image->image)); ?>" data-sub-html="<h4> <?php echo e(trans('home.image')); ?> <?php echo e($key+1); ?></h4>">
                                                    <a href="javascript:;">
                                                        <img class="img-responsive" src="<?php echo e(url('uploads/services/source/'.$image->image)); ?>" width="150px" height="150px">
                                                    </a>
                                                    <div>
                                                        <br>
                                                        <a href='#' data-image='<?php echo e($image->id); ?>' class='delete_img_btn btn btn-danger' ><?php echo e(trans('home.delete')); ?></a>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>

                                <?php endif; ?>
                                <div class="col-12">
                                    <br>
                                    <hr>
                                </div>
                                <div class="form-group col-md-12 mt-3">
                                    <hr>
                                    <h4 class="card-title mt-3 mb-3"><?php echo e(trans('home.faq')); ?></h4>
                                </div>
                                <div class="col-md-12">
                                    <div class="field_wrapper">
                                        <div class="row">
                                            <?php if(count($questions) > 0): ?>
                                                <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-md-5 mb-3">
                                                        <label for="question"><?php echo e(trans('home.writer')); ?></label>
                                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.writer')); ?>" readonly value="<?php echo e($question->question); ?>">
                                                    </div>

                                                    <div class="col-md-5 mb-3">
                                                        <label for="answer"><?php echo e(trans('home.answer')); ?></label>
                                                        <textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" readonly><?php echo e($question->answer); ?></textarea>
                                                    </div>

                                                    <div class="form-group col-md-2">
                                                        <button type="button" style="margin-top: 28px;" class="btn" data-bs-toggle="modal" data-bs-target="#iconForm_<?php echo e($key); ?>"><i class="fas fa-edit"></i></button>
                                                        <button type="button" style="margin-top: 28px;" class="btn rmv" data-faq_id="<?php echo e($question->id); ?>" id="type-error"><i class="fas fa-trash-alt"></i></button>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                                <div class="col-md-6 mb-3">
                                                    <label for="question"><?php echo e(trans('home.writer')); ?></label>
                                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.writer')); ?>" name="question[]">
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="answer"><?php echo e(trans('home.answer')); ?></label>
                                                    <textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer[]"></textarea>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <a href="javascript:void(0);" class="add_button btn m-2" title="Add field"><i class="fas fa-plus-square"></i></a>
                                </div>
                                <div class="col-12">
                                    <div class="row">
                                        <div class="form-group col-md-12">
                                            <hr>
                                            <span class="badge badge-success"><?php echo e(trans('home.en')); ?></span>
                                        </div>

                                        <div class="form-group col-md-2">
                                            <label for="link_en"><?php echo e(trans('home.slug')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(trans('home.slug')); ?>" name="link_en" value="<?php echo e($service->link_en); ?>">
                                        </div>

                                        <div class="form-group col-md-5">
                                            <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                            <textarea class="form-control" name="meta_title_en" placeholder="<?php echo e(trans('home.meta_title')); ?>"><?php echo e($service->meta_title_en); ?></textarea>
                                        </div>

                                        <div class="form-group col-md-5">
                                            <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                            <textarea class="form-control" name="meta_desc_en" placeholder="<?php echo e(trans('home.meta_desc')); ?>"><?php echo e($service->meta_desc_en); ?></textarea>
                                        </div>

                                        <div class="form-group col-md-12">
                                            <hr>
                                            <span class="badge badge-success"><?php echo e(trans('home.ar')); ?></span>
                                        </div>

                                        <div class="form-group col-md-2">
                                            <label for="link_ar"><?php echo e(trans('home.slug')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(trans('home.slug')); ?>" name="link_ar" value="<?php echo e($service->link_ar); ?>">
                                        </div>

                                        <div class="form-group col-md-5">
                                            <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                            <textarea class="form-control" name="meta_title_ar" placeholder="<?php echo e(trans('home.meta_title')); ?>"><?php echo e($service->meta_title_ar); ?></textarea>
                                        </div>

                                        <div class="form-group col-md-5">
                                            <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                            <textarea class="form-control" name="meta_desc_ar" placeholder="<?php echo e(trans('home.meta_desc')); ?>"><?php echo e($service->meta_desc_ar); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-3">

                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="status" id="switch" switch="success" <?php echo e(($service->status == 1)? 'checked':''); ?>  />
                                            <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>
                                        </div>
                                    </div>
                                    <div class="form-group col-3">

                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="home" id="switch1" switch="success" <?php echo e(($service->home == 1)? 'checked':''); ?>  />
                                            <label for="switch1" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch1"> <?php echo e(trans('home.home')); ?></label>
                                        </div>
                                    </div>
                                    <div class="form-group col-3">

                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="menu" id="switch17" switch="success" <?php echo e(($service->menu == 1)? 'checked':''); ?>  />
                                            <label for="switch17" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch17"> <?php echo e(trans('home.menu')); ?></label>
                                        </div>
                                    </div>
                                    <div class="form-group col-3">

                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="meta_robots" id="switch2" switch="success" <?php echo e(($service->meta_robots == 1)? 'checked':''); ?>  />
                                            <label for="switch2" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch2"> <?php echo e(trans('home.meta_robots')); ?></label>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-primary w-md"><i class="image-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(url('/admin/services')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="image-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>

                            </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
            <!-- Modal -->
    <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="modal fade text-left" id="iconForm_<?php echo e($key); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title" id="myModalLabel34"><?php echo e(trans('home.edit_faq')); ?></h3>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('updateFaq')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <label for="question"><?php echo e(trans('home.question')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" name="question" value="<?php echo e($question->question); ?>">
                            </div>

                            <div class="form-group col-md-12">
                                <label for="answer"><?php echo e(trans('home.answer')); ?></label>
                                <textarea type="text"  class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer" ><?php echo e($question->answer); ?></textarea>
                            </div>

                            <input type="hidden" name="faq_id" value="<?php echo e($question->id); ?>"/>

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><?php echo e(trans('home.save')); ?> </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/dropzone.js"></script>

    <script type="text/javascript">

        var token = "<?php echo e(csrf_token()); ?>";
        //Dropzone.autoDiscover = true;
        Dropzone.autoDiscover = false;

        $("div.upload_images").dropzone({

            addRemoveLinks: true,
            acceptedFiles: ".jpeg,.jpg,.png,.gif",
            url: "<?php echo e(URL::to('admin/services/uploadImages')); ?>",

            init: function() {
                this.on("sending", function(file, xhr, formData) {
                    formData.append("serviceId", <?php echo e($service->id); ?>);
                });
            },

            params: {
                _token: token,
                type: 'product_image',
            },

            removedfile: function(file) {

                var fileName = file.name;
                $.ajaxSetup({ headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') } });
                    $.ajax({
                    type: 'POST',
                    url: "<?php echo e(URL::to('admin/services/removeUploadImages')); ?>",
                    data: {type:'service_image',name: fileName,request: 'delete'},
                    sucess: function(data){
                        console.log('success: ' + data);
                    }
                });
                var _ref;
                return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
            }

        });


        Dropzone.options.myAwesomeDropzone = {
            paramName: "file", // The name that will be used to transfer the file
            maxFilesize: 3, // MB
            accept: function(file, done) {

            },
        };

        $('.delete_img_btn').on('click',function(){
            var image = $(this).data('image');
            var serviceId=<?php echo e($service->id); ?>;
            var btn = $(this);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:" <?php echo e(url('admin/services/deleteImege')); ?>",
                method:'POST',
                data:{image:image , serviceId:serviceId },
                success:function(data)
                {
                    location.href = "<?php echo e(route('services.edit',$service->id)); ?>";
                }
            });
        });



    </script>
  <script>

    $(document).ready(function(){
        var maxField = 100; //Input fields increment limitation
        var addButton = $('.add_button'); //Add button selector
        var wrapper = $('.field_wrapper'); //Input field wrapper
        var fieldHTML ='<div class="row"><div class="form-group col-md-6"><label for="question"><?php echo e(trans('home.question')); ?></label><input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" name="question[]"></div>';
        fieldHTML +='<div class="form-group col-md-5"><label for="answer"><?php echo e(trans('home.answer')); ?></label><textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer[]"></textarea></div>';
        fieldHTML +='<div class="form-group col-md-1"><a href="javascript:void(0);" style="margin-top: 30px;" class="remove_button btn"><i class="fas fa-trash-alt"></i></a></div></div>';

        var x = 1; //Initial field counter is 1

        //Once add button is clicked
        $(addButton).click(function(){
            //Check maximum number of input fields
            if(x < maxField){
                x++; //Increment field counter
                $(wrapper).append(fieldHTML); //Add field html
            }
        });

        //Once remove button is clicked
        $(wrapper).on('click', '.remove_button', function(e){
            e.preventDefault();
            $(this).parent().parent('div').remove(); //Remove field html
            x--; //Decrement field counter
        });
    });

    $(document).ready(function(){
        $('.rmv').click(function () {
            var faq_id = $(this).data('faq_id');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:"<?php echo e(route('removeFaq')); ?>",
                method:'POST',
                data: {faq_id:faq_id},
                success:function(data) {
                    location.reload();
                }
            });
        });

    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\drsobhy\resources\views/admin/services/editService.blade.php ENDPATH**/ ?>