<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.add_blog_item')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.blogItems')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/blog-items')); ?>"><?php echo e(trans('home.blogItems')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('home.add_blog_item')); ?></li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-4">
                    <div class="row">
                        <div class="col-lg-12">
                            <!-- End Page Header -->
                            <?php echo Form::open(['route' => 'blog-items.store', 'data-toggle'=>'validator', 'files'=>'true']); ?>

                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <label for="title_en"><?php echo e(trans('home.title_en')); ?></label>
                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.title_en')); ?>" name="title_en"  required>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="title_fr"><?php echo e(trans('home.title_fr')); ?></label>
                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.title_fr')); ?>" name="title_fr"  required>
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label for="title_ar"><?php echo e(trans('home.title_ar')); ?></label>
                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.title_ar')); ?>" name="title_ar" required>
                                    </div>

                                    <div class="col-md-12 mb-3">
                                        <label for="parent"><?php echo e(trans('home.blogCategory')); ?></label>
                                        <select class="form-control" data-trigger name="blogcategory_id">
                                            <?php $__currentLoopData = $blogCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blogCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($blogCategory->id); ?>" ><?php echo e((app()->getLocale()=='en')? $blogCategory->title_en:$blogCategory->title_ar); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label for="type"><?php echo e(trans('home.writers')); ?></label>
                                        <select class="form-control select2 type" name="writer_id">
                                            <?php $__currentLoopData = $writers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $writer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value ="<?php echo e($writer->id); ?>"><?php echo e($writer->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label for="code"><?php echo e(trans('home.date')); ?></label>
                                        <div class="input-group">
                                            <input type='text' class="form-control" name="date" placeholder="<?php echo e(trans('home.date')); ?>" id="datepicker"   required/>
                                            <div class="input-group-append">
                                                <span class="input-group-text">
                                                    <i class="fas fa-calendar"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-3 mt-3">
                                        <label for="formFile" class="form-label"><?php echo e(trans('home.choose_image')); ?></label>
                                        <input class="form-control" type="file" id="formFile" name="image">
                                    </div>

                                    <div class="col-md-4 mb-3 mt-3">
                                        <label ><?php echo e(trans('home.alt_img')); ?></label>
                                        <input class="form-control" name="alt_img" type="text" placeholder="<?php echo e(trans('home.alt_img')); ?>" />
                                    </div>  

                                    <div class="form-group col-md-6 ">
                                        <label for="text_en"><?php echo e(trans('home.text_en')); ?></label>
                                        <textarea class="form-control ckeditor-classic" name="text_en" placeholder="<?php echo e(trans('home.text_en')); ?>" ></textarea>
                                    </div>
                                    <div class="form-group col-md-6 ">
                                        <label for="text_fr"><?php echo e(trans('home.text_fr')); ?></label>
                                        <textarea class="form-control ckeditor-classic" name="text_fr" placeholder="<?php echo e(trans('home.text_fr')); ?>" ></textarea>
                                    </div>

                                    <div class="form-group col-md-6 ">
                                        <label for="text_ar"><?php echo e(trans('home.text_ar')); ?></label>
                                        <textarea class="form-control ckeditor-classic" name="text_ar" placeholder="<?php echo e(trans('home.text_ar')); ?>" ></textarea>
                                    </div>
                                    <div class="form-group col-md-12 mt-3">
                                        <hr>
                                        <h4 class="card-title mt-3 mb-3"><?php echo e(trans('home.faq')); ?></h4>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="field_wrapper">
                                            <div class="row">
                                                <div class="col-md-6 mb-3">
                                                    <label for="question"><?php echo e(trans('home.writer')); ?></label>
                                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.writer')); ?>" name="question[]">
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label for="answer"><?php echo e(trans('home.answer')); ?></label>
                                                    <textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer[]"></textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <a href="javascript:void(0);" class="add_button btn m-2" title="Add field"><i class="fas fa-plus-square"></i></a>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <hr>
                                        <h4 class="card-title mt-3 mb-3"><?php echo e(trans('home.seo_block')); ?></h4>
                                        <span class="badge-soft-primary"><?php echo e(trans('home.en')); ?></span>
                                    </div>

                                    <div class="col-md-2 mb-3">
                                        <label for="link_en"><?php echo e(trans('home.slug')); ?></label>
                                        <input type="text" class="form-control" placeholder="<?php echo e(trans('home.slug')); ?>" name="link_en">
                                    </div>

                                    <div class="col-md-5 mb-3">
                                        <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                        <textarea class="form-control" name="meta_title_en" placeholder="<?php echo e(trans('home.meta_title')); ?>"></textarea>
                                    </div>

                                    <div class="col-md-5 mb-3">
                                        <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                        <textarea class="form-control" name="meta_desc_en" placeholder="<?php echo e(trans('home.meta_desc')); ?>"></textarea>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <hr>
                                        <h4 class="card-title mt-3 mb-3"><?php echo e(trans('home.seo_block')); ?></h4>
                                        <span class="badge-soft-primary"><?php echo e(trans('home.fr')); ?></span>
                                    </div>

                                    <div class="col-md-2 mb-3">
                                        <label for="link_fr"><?php echo e(trans('home.slug')); ?></label>
                                        <input type="text" class="form-control" placeholder="<?php echo e(trans('home.slug')); ?>" name="link_fr">
                                    </div>

                                    <div class="col-md-5 mb-3">
                                        <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                        <textarea class="form-control" name="meta_title_fr" placeholder="<?php echo e(trans('home.meta_title')); ?>"></textarea>
                                    </div>

                                    <div class="col-md-5 mb-3">
                                        <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                        <textarea class="form-control" name="meta_desc_fr" placeholder="<?php echo e(trans('home.meta_desc')); ?>"></textarea>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <hr>
                                        <span class="badge-soft-primary"><?php echo e(trans('home.ar')); ?></span>
                                    </div>

                                    <div class="col-md-2 mb-3">
                                        <label for="link_ar"><?php echo e(trans('home.slug')); ?></label>
                                        <input type="text" class="form-control" placeholder="<?php echo e(trans('home.slug')); ?>" name="link_ar">
                                    </div>

                                    <div class="col-md-5 mb-3">
                                        <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                        <textarea class="form-control" name="meta_title_ar" placeholder="<?php echo e(trans('home.meta_title')); ?>"></textarea>
                                    </div>

                                    <div class="col-md-5 mb-3">
                                        <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                        <textarea class="form-control" name="meta_desc_ar" placeholder="<?php echo e(trans('home.meta_desc')); ?>"></textarea>
                                    </div>

                                </div>
                                <!-- Row-->
                                <div class="row">
                                    <div class="form-group col-4">
                                        
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="status" id="switch" switch="success" checked/>
                                            <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>
                                        </div>
                                    </div>
                                    <div class="form-group col-4">
                                        
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="home" id="switch1" switch="success" checked/>
                                            <label for="switch1" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch1"> <?php echo e(trans('home.home')); ?></label>
                                        </div>
                                    </div>
                                    <div class="form-group col-4">
                                        
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="meta_robots" id="switch2" switch="success" checked/>
                                            <label for="switch2" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch2"> <?php echo e(trans('home.meta_robots')); ?></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-4">
                                    <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                                    <a href="<?php echo e(url('/admin/blog-items')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                                <!-- frd Row -->
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function(){
            var maxField = 100; //Input fields increment limitation
            var addButton = $('.add_button'); //Add button selector
            var wrapper = $('.field_wrapper'); //Input field wrapper
            var fieldHTML ='<div class="row"><hr><div class="form-group col-md-6"><label for="question"><?php echo e(trans('home.question')); ?></label><input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" name="question[]"></div>';
            fieldHTML +='<div class="form-group col-md-5"><label for="answer"><?php echo e(trans('home.answer')); ?></label><textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer[]"></textarea></div>';
            fieldHTML +='<div class="form-group col-md-1"><a href="javascript:void(0);" style="margin-top: 30px;" class="remove_button btn"><i class="fas fa-trash-alt"></i></a></div></div>';

            var x = 1; //Initial field counter is 1

            //Once add button is clicked
            $(addButton).click(function(){
                //Check maximum number of input fields
                if(x < maxField){
                    x++; //Increment field counter
                    $(wrapper).append(fieldHTML); //Add field html
                }
            });

            //Once remove button is clicked
            $(wrapper).on('click', '.remove_button', function(e){
                e.preventDefault();
                $(this).parent().parent('div').remove(); //Remove field html
                x--; //Decrement field counter
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\ctc\resources\views/admin/blogItems/addBlogItem.blade.php ENDPATH**/ ?>