<title><?php echo e(trans('home.testimonials')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.testimonials')); ?></h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(trans('home.testimonials')); ?></li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <a href="<?php echo e(url('admin/testimonials/create')); ?>"><button class="btn ripple btn-primary col-md-2"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session()->pull('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        <div id="successmesg"  style="display: none; margin-bottom: 10px;"  class="alert alert-danger alert-dismissible fade show" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
          </div>
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card-body">
                    <table class="table" id="exportexample">
                        <thead>
                            <tr>
                                <th><input type="checkbox" class="form-check-input" id="checkAll"/></th>
                                <th><?php echo e(trans('home.id')); ?></th>
                                <th class="wd-20p"><?php echo e(trans('home.name')); ?></th>
                                <th class="wd-20p"><?php echo e(trans('home.image')); ?></th>
                                <th class="wd-20p"><?php echo e(trans('home.type')); ?></th>
                                <th><?php echo e(__('home.publish/unpublish')); ?></th>
                                <th><?php echo e(__('home.edit')); ?></th>
                                <th><?php echo e(__('home.delete')); ?>

                                    <div class="d-block">
                                        <a type="button" id="btn_delete" class="btn btn-danger waves-effect waves-light"onclick="return confirm('Are you sure you want to deletethis rows?');" ><?php echo e(__('home.delete')); ?></a>
                                    <div>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr id="<?php echo e($testimonial->id); ?>">
                                    <td> <input type="checkbox" name="checkbox"  class="tableChecked form-check-input" value="<?php echo e($testimonial->id); ?>"/></td>
                                    <td><a href="<?php echo e(route('testimonials.edit', $testimonial->id)); ?>"><?php echo e($testimonial->id); ?></a></td>
                                    <td><?php echo e($testimonial->{'name_'.$lang}); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('testimonials.edit', $testimonial->id)); ?>">
                                            <?php if($testimonial->img): ?>
                                                <img src="<?php echo e(url('/uploads/testimonials/source')); ?>/<?php echo e($testimonial->img); ?>" width="70">
                                            <?php else: ?>
                                                <img src="<?php echo e(url('resources/assets/back/images/noimage.jpg')); ?>" width="70">
                                            <?php endif; ?>
                                        </a>
                                    </td>
                                    <td><?php echo e($testimonial->type); ?></td>
                                    <td>
                                        <input class="btn_active" data-id="<?php echo e($testimonial->id); ?>" type="checkbox" id="switch-<?php echo e($testimonial->id); ?>" switch="success" <?php echo e($testimonial->status == 1?'checked':''); ?> />
                                        <label for="switch-<?php echo e($testimonial->id); ?>" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                    </td>
                                    <td>
                                        <a type="button" class="btn btn-info waves-effect waves-light "
                                            href="<?php echo e(route('testimonials.edit',$testimonial->id)); ?>" ><?php echo e(__('home.edit')); ?></a>
                                    </td>
                                    <td>
                                        <a type="button" class="btn btn-danger waves-effect waves-light btn_delete"
                                            data-id="<?php echo e($testimonial->id); ?>"><?php echo e(__('home.delete')); ?></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\albadr\resources\views/admin/testimonials/testimonials.blade.php ENDPATH**/ ?>