<?php $__env->startSection('meta'); ?>
<title><?php echo e(trans('home.edit_teams')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.teams')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/teams')); ?>"><?php echo e(trans('home.teams')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_team')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_team')); ?></h6>
                        </div>
                        <?php echo Form::open([
                            'method' => 'PATCH',
                            'url' => 'admin/teams/' . $team->id,
                            'data-toggle' => 'validator',
                            'files' => 'true',
                        ]); ?>

                        <div class="row">

                            <div class="form-group col-md-6 mb-3">
                                <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                <input class="form-control" name="name_en" type="text"
                                    placeholder="<?php echo e(trans('home.name_en')); ?>" value="<?php echo e($team->name_en); ?>">
                            </div>

                            <div class="form-group col-md-6 mb-3">
                                <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                <input class="form-control" name="name_ar" type="text"
                                    placeholder="<?php echo e(trans('home.name_ar')); ?>" value="<?php echo e($team->name_ar); ?>">
                            </div>
                            <div class="form-group col-md-6 mb-3">
                                <label class=""><?php echo e(trans('home.text_en')); ?></label>
                                <textarea class="form-control ckeditor-classic" name="text_en" type="text"
                                    placeholder="<?php echo e(trans('home.text_en')); ?>" value="<?php echo e($team->text_en); ?>"></textarea>
                            </div>

                            <div class="form-group col-md-6 mb-3">
                                <label class=""><?php echo e(trans('home.text_ar')); ?></label>
                                <textarea class="form-control ckeditor-classic" name="text_ar" type="text"
                                    placeholder="<?php echo e(trans('home.text_ar')); ?>" value="<?php echo e($team->text_ar); ?>"></textarea>
                            </div>
                            <div class="form-group col-md-6 mb-3">
                                <label class=""><?php echo e(trans('home.position_en')); ?></label>
                                <input class="form-control" name="position_en" type="text"
                                    placeholder="<?php echo e(trans('home.position_en')); ?>" value="<?php echo e($team->position_en); ?>">
                            </div>
                            <div class="form-group col-md-6 mb-3">
                                <label class=""><?php echo e(trans('home.position_ar')); ?></label>
                                <input class="form-control" name="position_ar" type="text"
                                    placeholder="<?php echo e(trans('home.position_ar')); ?>" value="<?php echo e($team->position_ar); ?>">
                            </div>

                            <div class="form-group col-md-4 mb-3">
                                <label class=""><?php echo e(trans('home.email')); ?></label>
                                <input class="form-control" name="email" type="text"
                                    placeholder="<?php echo e(trans('home.email')); ?>" value="<?php echo e($team->email); ?>">
                            </div>
                            
                            <div class="form-group col-md-4 mb-3">
                                <label class=""><?php echo e(trans('home.experience')); ?></label>
                                <input class="form-control" name="experience" type="text"
                                    placeholder="<?php echo e(trans('home.experience')); ?>" value="<?php echo e($team->experience); ?>">
                            </div>
                            <div class="form-group col-md-4 mb-3">
                                <label class=""><?php echo e(trans('home.mobile')); ?></label>
                                <input class="form-control" name="mobile" type="text"
                                    placeholder="<?php echo e(trans('home.mobile')); ?>" value="<?php echo e($team->mobile); ?>">
                            </div>

                            <div class="form-group col-md-4 mb-3">
                                <label class=""><?php echo e(trans('home.facebook')); ?></label>
                                <input class="form-control" name="facebook" type="text"
                                    placeholder="<?php echo e(trans('home.facebook')); ?>" value="<?php echo e($team->facebook); ?>">
                            </div>

                            <div class="form-group col-md-4 mb-3">
                                <label class=""><?php echo e(trans('home.instagram')); ?></label>
                                <input class="form-control" name="instgram" type="text"
                                    placeholder="<?php echo e(trans('home.instagram')); ?>" value="<?php echo e($team->instgram); ?>">
                            </div>
                             <div class="form-group col-md-4 mb-3">
                                <label class=""><?php echo e(trans('home.linkedin')); ?></label>
                                <input class="form-control" name="linkedin" type="text"
                                    placeholder="<?php echo e(trans('home.linkedin')); ?>" value="<?php echo e($team->linkedin); ?>">
                            </div>
                            
                            <div class="form-group col-md-9 mb-3">
                                <label class=""><?php echo e(trans('home.link')); ?></label>
                                <input class="form-control" name="link" type="text"
                                    placeholder="<?php echo e(trans('home.link')); ?>" value="<?php echo e($team->link); ?>">
                            </div>
                           <div class="row">
                            <div class="col-md-9 mb-3 mt-3 mb-3">
                                    <label for="formFile" class="form-label"><?php echo e(trans('home.choose_image')); ?></label>
                                    <input class="form-control" type="file" id="formFile" name="img">
                                </div>

                                <?php if($team->img): ?>
                                    <div class=" col-md-2 m-2 mt-3">
                                        <img src="<?php echo e(url('\uploads\teams\source')); ?>\<?php echo e($team->img); ?>" width="200" height="150">
                                    </div>
                                <?php else: ?>
                                    <div class=" col-md-3 mt-3">
                                        <img src="<?php echo e(url('resources/assets/back/images/noimage.jpg')); ?>" width="70">
                                    </div>
                                <?php endif; ?>
                            <div class="form-group col-3">
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="status" id="switch" switch="success" <?php echo e(($team->status == 1)? 'checked':''); ?>  />
                                            <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>
                                        </div>
                                    </div>
                            </div>
                            
                            <div class="row">
                                <h6><?php echo e(__('home.schedule')); ?></h6>
                                <?php $__currentLoopData = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $schedule = $schedules->firstWhere('day', $day);
                                    ?>
                                    <div class="form-group col-md-6">
                                        <label class=""><?php echo e(ucfirst($day)); ?> Start Time</label>
                                        <input class="form-control" name="schedule[<?php echo e($day); ?>][start]"
                                            type="time" placeholder="Start Time"
                                            value="<?php echo e(isset($schedule) ? $schedule->start_time : ''); ?>">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class=""><?php echo e(ucfirst($day)); ?> End Time</label>
                                        <input class="form-control" name="schedule[<?php echo e($day); ?>][end]"
                                            type="time" placeholder="End Time"
                                            value="<?php echo e(isset($schedule) ? $schedule->end_time : ''); ?>">
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                    <?php echo e(trans('home.save')); ?> </button>
                                <a href="<?php echo e(url('/admin/teams')); ?>"><button type="button"
                                        class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                        <?php echo e(trans('home.cancel')); ?></button></a>
                            </div>

                        </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest/public_html/ctc/resources/views/admin/teams/editteam.blade.php ENDPATH**/ ?>