<!DOCTYPE html>
<html lang="en" dir="ltr">



<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <?php echo $__env->yieldContent('title', 'Diamond Dental Academy'); ?>
    <?php echo $__env->yieldContent('meta'); ?>
    <!-- favicon -->
    <link rel="icon" href="<?php echo e(asset('resources/assets/front/images/logos/logo-small.png')); ?>" sizes="20x20"
        type="image/svg" />
    <!-- All CSS  -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"
        integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('slick.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('slick-theme.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('gallery.css')); ?>" />

    
</head>

<body class="body-shape">
    <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Preloader -->
    <div class="loader-wrapper">
        <div class="loader"></div>
        <div class="loader-section left"></div>
        <div class="loader-section right"></div>
    </div>

    <main id="wrapper" class="wrapper">
        <?php echo $__env->yieldContent('content'); ?>
    </main>
    <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <ul id="social-links" class="" style="transform: translate(15%, 100%);">
        <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($index == 0): ?>
                <li class="Icon call">
                    <!--<span class="tooltip">Call</span>-->
                    <a href="tel:<?php echo e($phone->code); ?><?php echo e($phone->phone); ?>"><span><i class="fas fa-phone"></i></span></a>
                </li>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php if($setting->whatsapp): ?>
            <li class="Icon whatsapp">
                <!--<span class="tooltip">whatsapp</span>-->
                <a href="https://wa.me/<?php echo e($setting->whatsapp); ?>" target="_blank"><span><i
                            class="fab fa-whatsapp"></i></span></a>
            </li>
        <?php endif; ?>
        <?php if($setting->instgram): ?>
            <li class="Icon instagram">
                <!--<span class="tooltip">whatsapp</span>-->
                <a href="<?php echo e($setting->instgram); ?>" target="_blank"><span><i
                            class="fab fa-instagram"></i></span></a>
            </li>
        <?php endif; ?>
        <?php if($setting->tiktok): ?>
            <li class="Icon tiktok">
                <!--<span class="tooltip">whatsapp</span>-->
                <a href="<?php echo e($setting->tiktok); ?>" target="_blank"><span><i
                            class="fab fa-tiktok"></i></span></a>
            </li>
        <?php endif; ?>
    </ul>
    <!-- Back to top -->
    <div class="back-to-top" id="back-icon">
        <img class="back-to-icon" src="<?php echo e(asset('resources/assets/front/images/icons/arrow-up-black.svg')); ?>"
            alt="Icon" />
    </div>

    <!-- JS ============================================ -->
    <!-- All JS -->
    <script src="<?php echo e(Helper::jsFilesPath('jquery-min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery-migrate.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('slick.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap-bundle.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('gallery.js')); ?>"></script>

    <script src="<?php echo e(Helper::jsFilesPath('gsap.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('ScrollTrigger.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('SplitText.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('app.js')); ?>"></script>
</body>

</html>
<?php /**PATH C:\OSPanel\domains\diamonddentalacademy\resources\views/layouts/app.blade.php ENDPATH**/ ?>