<title><?php echo e(trans('home.menu_items')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->

        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.menu_items')); ?></h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(trans('home.menu_items')); ?></li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <a href="<?php echo e(url('admin/menu-items/create')); ?>"><button class="btn ripple btn-primary col-md-2"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session()->pull('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        <div id="successmesg"  style="display: none; margin-bottom: 10px;"  class="alert alert-danger alert-dismissible fade show" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
          </div>
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                 <div class="card-body">
                    <div class="table-rep-plugin">
                        <div class="mb-0" data-pattern="priority-columns">
                            <table id="tech-companies-1" class="table table-striped text-center">
                                <thead>
                                    <tr>
                                        <th ><?php echo e(trans('home.id')); ?></th>
                                        <th ><?php echo e(trans('home.menu_name')); ?> <?php echo e(trans('home.en')); ?></th>
                                        <th ><?php echo e(trans('home.menu_parent')); ?></th>
                                        <th ><?php echo e(trans('home.menu_order')); ?></th>
                                        <th ><?php echo e(trans('home.menu_type')); ?></th>
                                        <th ><?php echo e(trans('home.menu')); ?></th>
                                        <th ><?php echo e(trans('home.menu_status')); ?></th>
                                        <th ><?php echo e(__('home.publish/unpublish')); ?></th>
                                        <th ><?php echo e(__('home.edit')); ?></th>
                                        <th ><?php echo e(__('home.delete')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $menuItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menuItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($menuItem->id); ?>">
                                            <td><a href="<?php echo e(route('menu-items.edit',$menuItem->id)); ?>"><?php echo e($menuItem->id); ?></td>
                                            <td><a><?php echo $menuItem->name_en; ?></a></td>
                                            <td><a><?php echo $menuItem->name_ar; ?></a></td>
                                            <td><a><?php if($menuItem->parent): ?> <?php echo e((app()->getLocale() == 'en')?$menuItem->parent->name_en:$menuItem->parent->name_ar); ?> <?php else: ?> <?php echo e(trans('home.main_menu_item')); ?> <?php endif; ?> </td>
                                            <td><a><?php echo e($menuItem->order); ?></td>
                                            <td><a><?php echo e($menuItem->type); ?></td>
                                            <td><a><?php if($menuItem->Menu): ?><?php echo e((app()->getLocale() == 'en')? $menuItem->Menu->name_en:$menuItem->Menu->name_ar); ?> <?php endif; ?></td>
                                            <td>
                                                <input class="btn_active" data-id="<?php echo e($menuItem->id); ?>" type="checkbox" id="switch-<?php echo e($menuItem->id); ?>" switch="success" <?php echo e($menuItem->status == 1?'checked':''); ?> />
                                                    <label for="switch-<?php echo e($menuItem->id); ?>" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            </td>
                                            <td>
                                                <a type="button" class="btn btn-info waves-effect waves-light "
                                                    href="<?php echo e(route('menu-items.edit',$menuItem->id)); ?>" ><?php echo e(__('home.edit')); ?></a>
                                            </td>
                                            <td>
                                                <a type="button" class="btn btn-danger waves-effect waves-light btn_delete"
                                                    data-id="<?php echo e($menuItem->id); ?>"><?php echo e(__('home.delete')); ?></a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\iris\resources\views/admin/menuItems/menuItems.blade.php ENDPATH**/ ?>