<!--Contact One Start-->
<section class="contact-one contact-home pb-5">
    <div class="contact-one__shape-1 float-bob-y">
        <img src="<?php echo e(url('resources/assets/front/images/shapes/contact-one-shape-1.png')); ?>" alt="shape">
    </div>
    <div class="container">
        <div class="row">

            <div class="col-md-6">
                <div class="contact-one__left">
                    <div class="contact-one__map">
                        <iframe src="<?php echo e($setting->map_url); ?>" width="100%" height="500" style="border:0;"
                            allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="contact-one__right">
                    <div class="contact-one__content-box">
                        <div class="section-title-two text-left">

                            <h2 class="section-title-two__title"><?php echo e(trans('home.contact_us')); ?></h2>
                        </div>
                        <form action="<?php echo e(LaravelLocalization::localizeUrl('save/contact-us')); ?>" method="POST"
                            class="contact-one__form contact-form-validated" novalidate="novalidate">
                            <div class="row">
                                <div class="col-xl-6">
                                    <div class="contact-one__input-box">
                                        <input type="text" placeholder="<?php echo e(trans('home.name')); ?>" name="name">
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="contact-one__input-box">
                                        <input type="email" placeholder="<?php echo e(trans('home.email')); ?>" name="email">
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="contact-one__input-box">
                                        <input type="number" placeholder="<?php echo e(trans('home.phone')); ?>" name="Phone">
                                    </div>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="contact-one__input-box text-message-box">
                                        <textarea name="message" placeholder="<?php echo e(trans('home.message')); ?>..."></textarea>
                                    </div>
                                    <div class="contact-one__btn-box">
                                        <button type="submit"
                                            class="button-style-1 btn-bg-white"><?php echo e(trans('home.send')); ?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <div class="result"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--Contact One End-->
<?php $__env->startSection('script'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

    <script>
        $(document).ready(function() {
            <?php if(Session::has('success')): ?>
                $.confirm({
                    title: "<?php echo e(trans('home.Success Message')); ?>",
                    content: "<?php echo e(Session::get('success')); ?>",
                    buttons: {
                        ok: {
                            text: "<?php echo e(trans('home.OK')); ?>",
                            btnClass: 'btn main-btn',
                        },
                    },
                    columnClass: 'col-md-6'
                });
            <?php endif; ?>
        });
    </script>
    <?php if($errors->any()): ?>
        <script>
            $(document).ready(function() {
                <?php if($errors->any()): ?>
                    $.confirm({
                        title: "<?php echo e(trans('home.Validation Errors')); ?>",
                        content: "<ul><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><li><?php echo e($error); ?></li><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></ul>",
                        buttons: {
                            ok: {
                                text: "<?php echo e(trans('home.OK')); ?>",
                                btnClass: 'btn main-btn',
                            },
                        },
                        columnClass: 'col-md-6'
                    });
                <?php endif; ?>
            });
        </script>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php /**PATH C:\OSPanel\domains\soulwater\resources\views/website/home-partials/contact.blade.php ENDPATH**/ ?>