<section class="section-padding2">
    <div class="container">
        <div class="row">
            <div class="col-md-12 animate-box" data-animate-effect="fadeInUp">
                <h2 class="section-title"> <?php echo e(__('home.contact')); ?><span><?php echo e(__('home.us')); ?></span></h2>
            </div>
        </div>

        <div class="row mb-90">
            <?php if($aboutStrucs): ?>
                <div class="col-md-4 mb-30 animate-box" data-animate-effect="fadeInUp">
                    <p><b><?php echo e($aboutStrucs->title); ?></b></p>
                    <p><?php echo e(strip_tags($aboutStrucs->text)); ?></p>
                </div>
            <?php endif; ?>


            <div class="col-md-4 mb-30 animate-box" data-animate-effect="fadeInUp">
                <p><b><?php echo e(__('home.ContactWithUs')); ?></b></p>
                <?php if($setting->mobile): ?>
                <p><b><?php echo e(__('home.phone')); ?> :</b> <?php echo e($setting->mobile); ?></p>
                <?php endif; ?>
                <?php if($setting->telphone): ?>
                <p><b><?php echo e(__('home.phone1')); ?> :</b> <?php echo e($setting->telphone); ?></p>
                <?php endif; ?>
                <?php if($setting->contact_email): ?>
                <p><b><?php echo e(__('home.contact_email')); ?> :</b> <?php echo e($setting->contact_email); ?></p>
                <?php endif; ?>
                <?php if($setting->address1): ?>
                <p><b><?php echo e(__('home.visit_us')); ?> :</b> <?php echo e($configration->address1); ?></p>
                <?php endif; ?>
            </div>
            <div class="col-md-4 animate-box" data-animate-effect="fadeInUp">
                <p><b><?php echo e(__('home.Contact Information')); ?></b></p>
                <form  action="<?php echo e(LaravelLocalization::localizeUrl('save/contact-us')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <!-- Form elements -->
                    <div class="row">
                        <div class="col-md-12 form-group">
                            <input name="name" type="text" placeholder="<?php echo e(__('home.name')); ?> *" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <input name="email" type="email" placeholder="<?php echo e(__('home.email')); ?> *" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <input name="phone" type="text" placeholder="<?php echo e(__('home.phone')); ?> *" required>
                        </div>
                        <div class="col-md-12 form-group">
                            <input name="title" type="text" placeholder="<?php echo e(__('home.title')); ?> *" required>
                        </div>
                        <div class="col-md-12 form-group">
                            <textarea name="message" id="message" cols="30" rows="4" placeholder="<?php echo e(__('home.message')); ?> *" required></textarea>
                        </div>
                        <div class="col-md-12">
                            <input  type="submit" value="<?php echo e(__('home.send_message')); ?>">
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

</section>

<?php $__env->startSection('script'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

    <script>
        $(document).ready(function() {
            <?php if(Session::has('success')): ?>
            $.confirm({
                title: "<?php echo e(trans('home.Success Message')); ?>",
                content: "<?php echo e(Session::get('success')); ?>",
                buttons: {
                    ok: {
                        text: "<?php echo e(trans('home.OK')); ?>",
                        btnClass: 'btn main-btn',
                    },
                },
                columnClass: 'col-md-6'
            });
            <?php endif; ?>
        });
    </script>
    <?php if($errors->any()): ?>
        <script>
            $(document).ready(function() {
                <?php if($errors->any()): ?>
                $.confirm({
                    title: "<?php echo e(trans('home.Validation Errors')); ?>",
                    content: "<ul><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><li><?php echo e($error); ?></li><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></ul>",
                    buttons: {
                        ok: {
                            text: "<?php echo e(trans('home.OK')); ?>",
                            btnClass: 'btn main-btn',
                        },
                    },
                    columnClass: 'col-md-6'
                });
                <?php endif; ?>
            });
        </script>

    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php /**PATH C:\OSPanel\domains\calibra\resources\views/website/home-partials/contact.blade.php ENDPATH**/ ?>