<title><?php echo e(trans('home.galleryImages')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.galleryImages')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.galleryImages')); ?></li>
                </ol>
            </div>
            <div class="btn btn-list">
                <a href="<?php echo e(url('admin/gallery-images/create')); ?>"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add-single')); ?></button></a>
                <a href="<?php echo e(url('admin/gallery-image/create-pluck')); ?>"><button class="btn ripple btn-success"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add-pluck')); ?></button></a>
                <a id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> <?php echo e(trans('home.publish/unpublish')); ?></button></a>
                <a id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> <?php echo e(trans('home.delete')); ?></button></a>
            </div>
        </div>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->pull('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <!-- Row-->
        <div class="row">
			<div class="col-lg-12 col-md-12">
				<div class="card custom-card">
					<div class="card-body">
						<div>
							<h6 class="card-title mb-1"><?php echo e(trans('home.galleryImages')); ?></h6>
							<p class="text-muted card-sub-title"><?php echo e(trans('home.list of all available gallery images')); ?></p>
						</div>
						
						
						<div class="table-responsive">
                            <table class="table" id="exportexample1">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" id="checkAll"/></th>
                                        <th><?php echo e(trans('home.id')); ?></th>
                                        <th><?php echo e(trans('home.image')); ?></th>
                                        <th><?php echo e(trans('home.order')); ?></th>
                                        <th><?php echo e(trans('home.status')); ?></th>
                                    </tr>
                                </thead>
                                <tbody class="sortable">
                                    <?php $__currentLoopData = $galleryImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $galleryImage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($galleryImage->id); ?>" data-id="<?php echo e($galleryImage->id); ?>"  class="image">
                                            <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="<?php echo e($galleryImage->id); ?>" /> </td>
                                            <td><a href="<?php echo e(route('gallery-images.edit', $galleryImage->id)); ?>"><?php echo e($galleryImage->id); ?></a></td>
                                            <td>
                                                <a href="<?php echo e(route('gallery-images.edit', $galleryImage->id)); ?>">
                                                    <?php if($galleryImage->img): ?>
                                                        <img src="<?php echo e(url('uploads/galleryImages/source/'.$galleryImage->img)); ?>" width="150">
                                                    <?php else: ?>
                                                        <img src="<?php echo e(url('resources/assets/back/img/noimage.png')); ?>" width="150">
                                                    <?php endif; ?>
                                                </a>
                                            </td>
                                            <td class="order"><?php echo e($galleryImage->order); ?></td>
                                            <td><a href="<?php echo e(route('gallery-images.edit', $galleryImage->id)); ?>"><?php if($galleryImage->status == 1): ?> <?php echo e(trans('home.yes')); ?> <?php else: ?>  <?php echo e(trans('home.no')); ?> <?php endif; ?></a></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
    					</div>
					</div>
				</div>
			</div>
		</div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        /////// make table row sortable ////
        $(document).ready(function () {
            var $images = $('.sortable');
            $images.sortable({
                connectWith: '.sortable',
                items: 'tr.image',
                stop: (event, ui) => {
                    sendReorderImagesRequest($(ui.item).parent());
    
                    if ($(event.target).data('id') != $(ui.item).parent().data('id')) {
                        if ($(event.target).find('tr.image').length) {
                            sendReorderImagesRequest($(event.target));
                        } else {
                            $(event.target).find('.empty-message').show();
                        }
                    }
                }
            });
            $('table, .sortable').disableSelection();
        });
        
        ////// send reorder request //////////////
        function sendReorderImagesRequest($image) {
            var items = $image.sortable('toArray', {attribute: 'data-id'});
            var ids = $.grep(items, (item) => item !== "");
            var _token = $('meta[name="csrf-token"]').attr('content');
            
            if ($image.find('tr.image').length) {
                $image.find('.empty-message').hide();
            }

            $.post('<?php echo e(url('admin/gallery-images/reorder')); ?>', {
                _token,
                ids,
            })
            .done(function (response) {
                $image.children('tr.image').each(function (index, image) {
                    $(image).children('.order').text(response.positions[$(image).data('id')])
                });
            })
            .fail(function (response) {
                alert('Error occured while sending reorder request');
                location.reload();
            });
        }

    </script>
<?php $__env->stopSection(); ?>    

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\Almashreq\resources\views/admin/galleryImages/galleryImages.blade.php ENDPATH**/ ?>