<!--=====BLOG AREA START=======-->
@if (isset($blogs) && count($blogs) > 0)
    <!--==================================================-->
    <!-- Start roadly Blog Area -->
    <!--==================================================-->
    <section class="blog_area style-three">
        <div class="container">
            @if (empty(Request::segment(2)))
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section_title text-center">
                            <h4>{{ __('home.blogs') }}</h4>
                            <h1>{{ __('home.Latest posts & articles') }}</h1>
                        </div>
                    </div>
                </div>
            @endif
            <div class="row">
                @foreach ($blogs as $blog)
                    <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".6s"
                        style="visibility: visible; animation-delay: 0.4s; animation-name: fadeInUp;">
                        <div class="single-blog-box">
                            <div class="single-blog-thumb">
                                <img src="{{ Helper::uploadedImagesPath('blogitems', $blog->image) }}" alt="thumb">
                            </div>
                            <div class="blog-content">
                                <div class="blog-title">
                                    <h3><a
                                            href="{{ LaravelLocalization::localizeUrl('blog/' . $blog->{'link_' . $lang}) }}">{{ $blog->{'title_' . $lang} }}</a>
                                    </h3>
                                </div>
                                <p class="blog-description">{{ Helper::extractFirstWords($blog->text) }}</p>
                                <div class="blog-btn">
                                    <a href="blog-details.html">{{ __('home.View More Blogs') }}<i
                                            class="flaticon flaticon-right-arrow"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            @if (empty(Request::segment(2)))
                <div class="banner_btn roadly_btn pt-5 text-center">
                    <a href="{{ LaravelLocalization::localizeUrl('blogs') }}">{{ __('home.read_more') }}<span
                            style="top: 313px; left: 89.9844px;"></span></a>
                </div>
            @endif
        </div>
    </section>
    <!--==================================================-->
    <!-- End roadly Blog Area -->
    <!--==================================================-->
@endif
<!--=====BLOG AREA END=======-->
