@extends('layouts.admin')
@section('meta')
<title>{{trans('home.edit_intro_sliders')}}</title>
@endsection
@section('content')

<div class="container-fluid">


    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{trans('home.intro_sliders')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                        <li class="breadcrumb-item"><a href="{{url('/admin/intro-sliders')}}">{{trans('home.intro_sliders')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('home.edit_slider')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>

        <!-- Row-->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{trans('home.edit_slider')}}</h4>
                    </div>
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                {!! Form::open(['method'=>'PATCH','url' => 'admin/intro-sliders/'.$slider->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                                <label class="">{{trans('home.title_en')}}</label>
                                                <input class="form-control" name="title_en" type="text" placeholder="{{trans('home.title_en')}}" value="{{$slider->title_en}}">
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="">{{trans('home.title_ar')}}</label>
                                                <input class="form-control" name="title_ar" type="text" placeholder="{{trans('home.title_ar')}}" value="{{$slider->title_ar}}">
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="">{{trans('home.text_en')}}</label>
                                                <textarea class="form-control ckeditor-classic" id="ckeditor-classic" name="text_en"  placeholder="{{trans('home.text_en')}}">{!! $slider->text_en !!}</textarea>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="">{{trans('home.text_ar')}}</label>
                                                <textarea class="form-control ckeditor-classic" id="ckeditor-classic" name="text_ar"  placeholder="{{trans('home.text_ar')}}">{!! $slider->text_ar !!}</textarea>
                                            </div>

                                            <!--<div class="col-md-6 mb-3">-->
                                            <!--    <label for="helperText">{{trans('home.lang')}}</label>-->
                                            <!--    <select class="form-control" col-md-6 mb-3 name="lang" required>-->
                                            <!--        <option value="en">{{trans('home.english')}}</option>-->
                                            <!--        <option value="ar">{{trans('home.arabic')}}</option>-->
                                            <!--    </select>-->
                                            <!--</div>-->


                                            <div class="col-md-6 mb-3">
                                                <label class="">{{trans('home.link')}}</label>
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text">http://www.google.com</span>
                                                    </div>
                                                    <input type="text" class="form-control" name="link" placeholder="{{trans('home.link')}}"  value="{{$slider->link}}">

                                                </div>
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label class="">{{trans('home.order')}}</label>
                                                <input class="form-control" name="order" type="number" min="0" autocomplete="off" placeholder="{{trans('home.order')}}" value="{{$slider->order}}">
                                            </div>


                                            <div class="col-md-6 mb-3">
                                                <label for="formFile" class="form-label">{{ trans('home.choose_image') }}</label>
                                                <input class="form-control" type="file" id="formFile" name="image">
                                            </div>

                                            @if($slider->image)
                                                <div class="form-group  col-md-6">
                                                    <img src="{{url('\uploads\sliders\intro-sliders\source')}}\{{$slider->image}}" width="350" height="150">                                    </div>
                                                </div>
                                            @endif
                                            <div class="col-md-6 mb-3">
                                            <label class="">{{trans('home.type')}}</label>
                                           <select name="type" class="form-control" data-trigger>
                                               <option value="">{{ trans('home.choose') }}</option>
                                               <option value="about" {{($slider->type=='about') ? 'selected':''}} >{{ trans('home.about-us') }}</option>
                                                <option value="services"  {{($slider->type=='services') ? 'selected':''}}>{{ trans('home.services') }}</option>
                                                <option value="gallery"  {{($slider->type=='gallery') ? 'selected':''}}>{{ trans('home.gallery') }}</option>
                                                <option value="contact"  {{($slider->type=='contact') ? 'selected':''}}>{{ trans('home.contact-us') }}</option>
                                                <option value="blogs"  {{($slider->type=='blogs') ? 'selected':''}}>{{ trans('home.blogs') }}</option>
                                                <option value="teams"  {{($slider->type=='teams') ? 'selected':''}}>{{ trans('home.teams') }}</option>
                                                <option value="projects"  {{($slider->type=='projects') ? 'selected':''}}>{{ trans('home.projects') }}</option>
                                                <option value="faq"  {{($slider->type=='faq') ? 'selected':''}}>{{ trans('home.faq') }}</option>
                                           </select>
                                        </div>
                                        </div>

                                        <div class="form-group">

                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="status" id="switch" switch="success" {{($slider->status == 1)? 'checked':''}}  />
                                                <label for="switch" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>
                                                <label class="form-check-label mx-3" for="switch"> {{trans('home.publish')}}</label>
                                            </div>
                                        </div>
                                        <div class="mt-4">
                                            <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}}</button>
                                            <a href="{{url('/admin/intro-sliders')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                        </div>
                                    </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

@endsection
