<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\ModelsServiceImage;

class Service extends Model
{
    public function images()
    {
        return ServiceImage::where('service_id', $this->id)->get();
    }

    public function writer()
    {
        return $this->belongsTo('App\Models\Writer', 'writer_id', 'id');
    }
    public function quotes(){
	    return $this->hasMany('App\Models\Faq')->select('question','answer');
    }
    
    public function childs()
    {
        return $this->hasMany(Service::class, 'parent_id')->where('status', 1)->orderBy('order', 'asc')->take(4);
    }
    public function messages()
    {
        return $this->hasMany(ContactUs::class, 'service_id');
    }

}
