<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_project')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
<style>
    img {
        display:block !important;
    }
    .dz-hidden-input{
        position: absolute !important;
        top: 0px !important;
        left: 250px !important;
    }

</style>
<link href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/min/dropzone.min.css" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.projects')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/projects')); ?>"><?php echo e(trans('home.projects')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_project')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_project')); ?></h6>
                        </div>
                        <?php echo Form::open(['method'=>'PATCH','url' => 'admin/projects/'.$project->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                            <div class="row">

                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                    <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>" value="<?php echo e($project->name_en); ?>" required>
                                </div>

                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                    <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>"value="<?php echo e($project->name_ar); ?>" >
                                </div>
                                <div class="form-group col-md-3">
                                    <label for="youtube_link"><?php echo e(trans('home.youtube_link')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.youtube_link')); ?>" name="youtube_link">
                                </div>
								<div class="form-group col-md-3">
                                    <label for="order"><?php echo e(trans('home.order')); ?></label>
                                    <input type="number" min="0"  class="form-control" placeholder="<?php echo e(trans('home.order')); ?>" name="order" value="<?php echo e($project->order); ?>">
                                </div>
                                
                                
                                
                                
                                <div class="form-group col-md-6">
                                    <label for="helperText"><?php echo e(trans('home.type')); ?></label>
                                    <select class="form-control select2" name="type" required>
                                        <option value="steelStructure" <?php echo e(($project->type == 'steelStructure')?'selected':''); ?>><?php echo e(trans('home.steelStructure')); ?></option>
                                        <option value="TOWERS" <?php echo e(($project->type == 'TOWERS')?'selected':''); ?>><?php echo e(trans('home.TOWERS')); ?></option>
                                        <option value="SEMI-TRAILERS" <?php echo e(($project->type == 'SEMI-TRAILERS')?'selected':'SEMI-TRAILERS'); ?>><?php echo e(trans('home.SEMI-TRAILERS')); ?></option>
                                        <option value="ELECTRO-MECHANICAL" <?php echo e(($project->type == 'ELECTRO-MECHANICAL')?'selected':''); ?>><?php echo e(trans('home.ELECTRO MECHANICAL')); ?></option>
                                    </select>
                                </div>
                                
                                
                                
                                

                                <div class="col-md-4">
                                    <label><?php echo e(trans('home.main_image')); ?></label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="image">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group col-md-2">
                                    <label for="alt_img"> <?php echo e(trans('home.alt_img')); ?></label>
                                    <input class="form-control" name="alt_img" type="text" placeholder="<?php echo e(trans('home.alt_img')); ?>" value="<?php echo e($project->alt_img); ?>">
                                </div>
                                
                                <?php if($project->image): ?>
                                    <div class="col-md-12">
                                        <img src="<?php echo e(url('\uploads\projects\resize200')); ?>\<?php echo e($project->image); ?>" width="150">
                                    </div>
                                <?php endif; ?>
                                
                                <div class="form-group col-md-6">
                                    <label for="text_en"> <?php echo e(trans('home.text_en')); ?></label>
                                    <textarea class="form-control area1" name="text_en" placeholder="<?php echo e(trans('home.text_en')); ?>"><?php echo e($project->text_en); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="text_ar"> <?php echo e(trans('home.text_ar')); ?></label>
                                    <textarea class="form-control area1" name="text_ar" placeholder="<?php echo e(trans('home.text_ar')); ?>"><?php echo e($project->text_ar); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="meta_keywords"> <?php echo e(trans('home.meta_keywords')); ?></label>
                                    <textarea class="form-control" name="meta_keywords" placeholder="<?php echo e(trans('home.meta_keywords')); ?>"><?php echo e($project->meta_keywords); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="meta_description"> <?php echo e(trans('home.meta_description')); ?></label>
                                    <textarea class="form-control" name="meta_description" placeholder="<?php echo e(trans('home.meta_description')); ?>"><?php echo e($project->meta_description); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-12">
                                    <hr>
                                    <label for="images"><?php echo e(trans('home.project_images')); ?></label>
                                        <div class="dropzone col-md-12 upload_images">
                                    </div>
                                </div>
                                
                                <?php if($project->images()): ?>
                                    <div class="col-md-12">
                                        <div class="row mb-0">
                                            <?php $__currentLoopData = $project->images(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-xs-6 col-sm-2 col-md-2 col-xl-2 mb-2 pl-sm-2 pr-sm-2">
                                                    <img class="img-responsive" src="<?php echo e(url('uploads/projects/source/'.$image->image)); ?>" height="150">
                                                    
                                                    <div>
                                                        <a href='#' data-image='<?php echo e($image->id); ?>' class='delete_img_btn' ><?php echo e(trans('home.delete')); ?></a>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="status" value="1" <?php echo e(($project->status == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                    </label>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(url('/admin/projects')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                                
                            </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/dropzone.js"></script>
    
    <script type="text/javascript">

        var token = "<?php echo e(csrf_token()); ?>";
        //Dropzone.autoDiscover = true;
        Dropzone.autoDiscover = false;

        $("div.upload_images").dropzone({
            
            addRemoveLinks: true,
            acceptedFiles: ".jpeg,.jpg,.png,.gif,.webp",
            url: "<?php echo e(URL::to('admin/projects/uploadImages')); ?>",

            init: function() {
                this.on("sending", function(file, xhr, formData) {
                    formData.append("projectId", <?php echo e($project->id); ?>);
                });
            },
            
            params: {
                _token: token,
                type: 'product_image',
            },

            removedfile: function(file) {

                var fileName = file.name; 
                $.ajaxSetup({ headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') } });
                    $.ajax({
                    type: 'POST',
                    url: "<?php echo e(URL::to('admin/projects/removeUploadImages')); ?>",
                    data: {type:'project_image',name: fileName,request: 'delete'},
                    sucess: function(data){
                        console.log('success: ' + data);
                    }
                });
                var _ref;
                return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
            }

        });
        
    
        Dropzone.options.myAwesomeDropzone = {
            paramName: "file", // The name that will be used to transfer the file
            maxFilesize: 3, // MB
            accept: function(file, done) {

            },
        };
        
        
        $('.delete_img_btn').on('click',function(){
            var image = $(this).data('image');
            var projectId=<?php echo e($project->id); ?>;
            var btn = $(this);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:" <?php echo e(url('admin/projects/deleteImege')); ?>",
                method:'POST',
                data:{image:image , projectId:projectId },
                success:function(data)
                {
                    location.href = "<?php echo e(route('projects.edit',$project->id)); ?>";
                }
            });
        });

    </script>
    
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest2/public_html/nomw/resources/views/admin/projects/editProject.blade.php ENDPATH**/ ?>