<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_about')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.about')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/about')); ?>"><?php echo e(trans('home.about')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_about')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->pull('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title "><?php echo e(trans('home.edit_about')); ?></h6>
                        </div>
                        <?php echo Form::open(['method'=>'PATCH','route' => 'admin.about.update', 'data-toggle'=>'validator', 'files'=>'true']); ?>

                            <div class="row">

                                <div class="form-group col-md-3 "> 
                                    <fieldset class="form-group">
                                        <label for="title_en"><?php echo e(trans('home.title_en')); ?></label>
                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.title_en')); ?>" name="title_en" value="<?php echo e($about->title_en); ?>">
                                    </fieldset>
                                </div>

                                <div class="form-group col-md-3 ">     
                                    <fieldset class="form-group">
                                        <label for="title_ar"><?php echo e(trans('home.title_ar')); ?></label>
                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.title_ar')); ?>" name="title_ar" value="<?php echo e($about->title_ar); ?>">
                                    </fieldset>
                                </div>

                                <div class="form-group col-md-3">
                                    <label for="youtube_link"><?php echo e(trans('home.youtube_link')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.youtube_link')); ?>" name="youtube_link" value="<?php echo e($about->youtube_link); ?>">
                                </div>
								<div class="form-group col-md-3">
                                    <label><?php echo e(trans('home.pdf')); ?></label>
                                    <div class="input-group ">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="pdf">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_pdf')); ?></label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group col-md-6 ">    
                                    <fieldset class="form-group">
                                        <label for="text_en"><?php echo e(trans('home.text_en')); ?></label>
                                        <textarea class="form-control area1" placeholder="<?php echo e(trans('home.text_en')); ?>" name="text_en"><?php echo $about->text_en; ?></textarea>
                                    </fieldset>
                                </div>

                                <div class="form-group col-md-6 ">    
                                    <fieldset class="form-group">
                                        <label for="text_ar"><?php echo e(trans('home.text_ar')); ?></label>
                                        <textarea class="form-control area1" placeholder="<?php echo e(trans('home.text_ar')); ?>" name="text_ar"><?php echo $about->text_ar; ?></textarea>
                                    </fieldset>
                                </div>

                                <div class="form-group col-md-6">
                                    <label><?php echo e(trans('home.image')); ?></label>
                                    <div class="input-group ">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="image">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label><?php echo e(trans('home.banner')); ?></label>
                                    <div class="input-group ">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="banner">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_banner')); ?></label>
                                        </div>
                                    </div>
                                </div>
                                

                                <?php if($about->image): ?>
                                    <div class="form-group col-md-6">
                                        <img src="<?php echo e(url('\uploads\aboutStrucs\resize200')); ?>\<?php echo e($about->image); ?>" width="150">
                                    </div>
                                <?php endif; ?>
                                
                                <?php if($about->banner): ?>
                                    <div class="form-group col-md-6">
                                        <img src="<?php echo e(url('\uploads\aboutStrucs\resize200')); ?>\<?php echo e($about->banner); ?>" width="150">
                                    </div>
                                <?php endif; ?>

                                <br>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(url('/admin')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                                
                            </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest2/public_html/bmk/resources/views/admin/about/editAbout.blade.php ENDPATH**/ ?>