<?php

namespace App\Http\Controllers;

use App\Models\ContactUs;
use DB;
use File;
use Image;
use Illuminate\Http\Request;

class ContactusController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct(){
        $this->middleware(['permission:contactUs']);
    }

    public function index()
    {
        $contactUsMessages = ContactUs::orderBy('id','DESC')->get();
        return view('admin.contactUsMessages.contactUsMessages',compact('contactUsMessages'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $contactUsMessage=ContactUs::find($id);
        if($contactUsMessage){
            $contactUsMessage->admin_seen = 1;
            $contactUsMessage->save();
            return view('admin.contactUsMessages.contactUsMessage_details',compact('contactUsMessage'));
        }else{
            abort('404');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ids)
    {
        //
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        
        foreach ($ids as $id) {
            $contactUsMessage = ContactUs::findOrFail($id);
            $contactUsMessage->delete();
            return redirect()->url('/admin/contact-us-messages')->with('success',trans('home.message successfully deleted'));

        }
    }  
    
}
