<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Album extends Model
{
    protected $table = 'album';
    protected $guarded = ['id', 'created_at', 'updated_at'];
    
    public function images(){
        return $this->hasMany(AlbumItem::class,'album_id');
    }
    
    public function firstImage(){
        return AlbumItem::where('album_id',$this->id)->first();
    }


}
