
@extends('layouts.app')
@section('meta')
<title> @lang('home.wishlist')</title>
@endsection
@section('content')
@include('website.banner' ,['bannerTitle' => __('home.wishlist')])

        <!-- Section Product -->
        <section class="flat-spacing-2">
            <div class="container">
                <div class="grid-layout wrapper-shop" data-grid="grid-4">
                    @foreach ($wishlists as $wishlist)
                         @include('website.card-product' , ['cartProduct' => $wishlist->product , 'cartProductId' => 'best-seller-'.$wishlist->product?->link ])
                    @endforeach
                </div>
            </div>
        </section>
        <!-- /Section Product -->
@endsection

@section('script')
<script>
    $(function () {
        $(document).on('click', '.wishlist', function () {
            const element = $(this);

            // Wait for other functions tied to this click event
            setTimeout(function () {
                // Check if there are ongoing AJAX requests
                $(document).ajaxComplete(function () {
                    if (element.hasClass('add-to-wishlist')) {
                        element.closest('.card-product').remove();
                    }
                });
            }, 0); // Schedule execution at the end of the event queue
        });
    });
</script>

@endsection
