@extends('layouts.app')
@section('meta')
    <title> @lang('home.my_orders')</title>
@endsection
@section('content')

@include('website.banner', [
    'bannerTitle' =>__('home.my_orders'),
])
        <!-- page-cart -->
        <section class="flat-spacing-11">
            <div class="container">
                <div class="row">
                    @include('website.user.links')
                    <div class="col-lg-9">
                        <div class="my-account-content account-order">
                            <div class="wrap-account-order">
                                <table>
                                    <thead>
                                        <tr>
                                            <th class="fw-6">@lang('home.order')</th>
                                            <th class="fw-6">@lang('date')</th>
                                            <th class="fw-6">@lang('home.status')</th>
                                            <th class="fw-6">@lang('home.total')</th>
                                            <th class="fw-6">@lang('home.action')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($orders   as $order )
                                            <tr class="tf-order-item">
                                                <td>
                                                    {{$order->number}}
                                                </td>
                                                <td>
                                                    {{ $order->created_at }}
                                                </td>
                                                <td>
                                                    {{$order->status_current}}
                                                </td>
                                                <td>
                                                    {{ $order->total }} ({{$order->products->count()}} @lang('home.Items'))
                                                </td>
                                                <td>
                                                    <a href="{{LaravelLocalization::localizeUrl('dashboard/my-order-details/'.$order->number)}}" class="tf-btn btn-fill animate-hover-btn rounded-0 justify-content-center">
                                                        <span>@lang('home.view')</span>
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- page-cart -->
@endsection
