@extends('layouts.app')
@section('meta')
    <title> @lang('home.addresses')</title>
@endsection
@section('content')

@include('website.banner', [
    'bannerTitle' =>__('home.addresses'),
])
        <!-- page-cart -->
        <section class="flat-spacing-11">
            <div class="container">
                <div class="row">
                    @include('website.user.links')

                    <div class="col-lg-9">
                        <div class="my-account-content account-address">
                            <div class="text-center widget-inner-address">
                                <button class="tf-btn btn-fill animate-hover-btn btn-address mb_20">@lang('home.add_address')</button>
                                <form class="show-form-address wd-form-address" id="formnewAddress"method="post" action="{{LaravelLocalization::localizeUrl('dashboard/add-address')}}">
                                    @csrf
                                    <div class="title">@lang('home.add_address')</div>
                                    <fieldset class="box fieldset">
                                        <label for="country">@lang('home.country')</label>
                                        <div class="select-custom">
                                            <select class="tf-select w-100 get-regions" id="country" name="country_id" >
                                                <option value="">@lang('home.country')</option>
                                                @foreach ($countries as $country)
                                                    <option @selected(old('country_id')  == $country->id ) value="{{$country->id}}"> {{$country->name}} </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </fieldset>

                                    <fieldset class="box fieldset">
                                        <label for="region">@lang('home.region')</label>
                                        <div class="select-custom" id="region-container">
                                            <select class="tf-select w-100 get-areas" id="region" name="region_id" data-default="">
                                            <option value="">@lang('home.region')</option>
                                            @foreach ($regions as $region)
                                                <option @selected(old('region_id')  == $region->id ) value="{{$region->id}}"> {{$region->name}} </option>
                                            @endforeach
                                        </select>
                                        </div>
                                    </fieldset>

                                    <fieldset class="box fieldset">
                                        <label for="region">@lang('home.area')</label>
                                        <div class="select-custom" id="area-container">
                                            <select class="tf-select w-100  get-shipping-fees" id="area" name="area_id" >
                                                <option value="">@lang('home.area')</option>
                                                @foreach ($areas as $area)
                                                    <option @selected(old('area_id') == $area->id ) value="{{$area->id}}">{{$area->name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </fieldset>

                                    <fieldset class="box fieldset">
                                        <label for="address">@lang('address')</label>
                                        <input type="text" id="address" name="address" value="{{old('address')}}" >
                                    </fieldset>
                                    <fieldset class="box fieldset">
                                        <label for="phone">@lang('home.phone')</label>
                                        <input type="number" id="phone" name="phone" value="{{old('phone')}}"   >
                                    </fieldset>

                                    <div class="box-field text-start">
                                        <div class="box-checkbox fieldset-radio d-flex align-items-center gap-8">
                                            <input type="checkbox" id="check-new-address" name="is_primary" checked value="1" class="tf-check">
                                            <label for="check-new-address" class="text_black-2 fw-4"> @lang('default_address')</a>.</label>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center justify-content-center gap-20">
                                        <button type="submit" class="tf-btn btn-fill animate-hover-btn"> @lang('home.save') </button>
                                        <span class="tf-btn btn-fill animate-hover-btn btn-hide-address">@lang('home.cancel')</span>
                                    </div>
                                </form>
                                <div class="list-account-address">
                                    @foreach ($addresses as $address)
                                        <div class="account-address-item">
                                            @if ($address->is_primary)
                                                <h6 class="mb_20">@lang('messages.address is now primary')</h6>
                                            @endif

                                            <p> {{ $address->address }} ({{$address->land_mark}})</p>
                                            <p>{{ $address->area_name }}</p>
                                            <p>{{ $address->region_name }}</p>
                                            <p>{{ $address->country_name }}</p>
                                            <p class="mb_10">{{ $address->phone }}</p>
                                            <div class="d-flex gap-10 justify-content-center">
                                                <button class="tf-btn btn-fill animate-hover-btn justify-content-center btn-edit-address">
                                                    <span>@lang('home.edit')</span>
                                                </button>
                                                <button class="tf-btn btn-outline animate-hover-btn justify-content-center">
                                                    <span onclick="deleteAddress('address{{$address->id}}')" >@lang('home.delete')</span>
                                                </button>
                                            </div>
                                            <form action="{{LaravelLocalization::localizeUrl('dashboard/delete-address/'. $address->id)}}" id="address{{$address->id}}" method="post">
                                                @method('delete')
                                                @csrf
                                            </form>
                                            <form class="edit-form-address wd-form-address" method="post" action="{{LaravelLocalization::localizeUrl('dashboard/update-address/'. $address->id)}}">
                                                @method('patch')
                                                @csrf
                                                <div class="title">@lang('home.edit_address')</div>
                                                <fieldset class="box field">
                                                    <label for="country-{{$address->id}}">@lang('home.country')</label>
                                                    <div class="select-custom">
                                                        <select class="tf-select w-100 get-regions-edit" id="country-{{$address->id}}"  name="country_id" >
                                                            <option value="">@lang('home.country')</option>
                                                            @foreach ($countries as $country)
                                                                <option @selected($address->country_id  == $country->id ) value="{{$country->id}}"> {{$country->name}} </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </fieldset>

                                                <fieldset class="box fieldset">
                                                    <label for="region-{{$address->id}}">@lang('home.region')</label>
                                                    <div class="select-custom region-container">
                                                        <select class="tf-select w-100 get-areas-edit" id="region-{{$address->id}}" name="region_id"   data-default="">
                                                            <option value="">@lang('home.region')</option>
                                                            @foreach ($regions as $region)
                                                                <option @selected($address->region_id  == $region->id ) value="{{$region->id}}"> {{$region->name}} </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </fieldset>

                                                <fieldset class="box fieldset">
                                                    <label for="area-{{$address->id}}">@lang('home.area')</label>
                                                    <div class="select-custom area-container">
                                                        <select class="tf-select w-100 " id="area-{{$address->id}}" name="area_id" >
                                                            <option value="">@lang('home.area')</option>
                                                            @foreach ($areas as $area)
                                                                <option @selected($address->area_id == $area->id ) value="{{$area->id}}">{{$area->name}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </fieldset>

                                                <fieldset class="box fieldset">
                                                    <label for="address-{{$address->id}}">@lang('address')</label>
                                                    <input type="text" id="address-{{$address->id}}"  name="address" value="{{$address->address}}" >
                                                </fieldset>
                                                <fieldset class="box fieldset">
                                                    <label for="phone-{{$address->id}}">@lang('home.phone')</label>
                                                    <input type="number" id="phone-{{$address->id}}"  name="phone" value="{{$address->phone}}"   >
                                                </fieldset>

                                                <div class="box-field text-start">
                                                    <div class="box-checkbox fieldset-radio d-flex align-items-center gap-8">
                                                        <input type="checkbox" id="primary-{{$address->id}}" name="is_primary" @checked($address->is_primary) value="1" class="tf-check">
                                                        <label for="primary-{{$address->id}}" class="text_black-2 fw-4"> @lang('home.Main Address')</a></label>
                                                    </div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-center gap-20">
                                                    <button type="submit" class="tf-btn btn-fill animate-hover-btn">@lang('home.update')</button>
                                                    <a  href="javascript:void(0)"   class="tf-btn btn-outline animate-hover-btn justify-content-center">
                                                        <span>@lang('home.cancel')</span>
                                                    </a>
                                                </div>
                                            </form>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- page-cart -->
@endsection
@section('script')
@include('website.scripts.checkout.get-regions') ;
@include('website.scripts.checkout.get-areas') ;
@include('website.scripts.checkout.get-shipping-fees') ;
<script>

    function deleteAddress(id) {
        console.log(12345);

        Swal.fire({
            title: "@lang('home.delete?')",
            text: "@lang('home.Are you sure you want to delete that ?')!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: " @lang('home.yes, delete it')!"
            }).then((result) => {
            if (result.isConfirmed) {
               document.getElementById(id).submit()
            }
            });
    }

</script>
@endsection
