@extends('layouts.app')
@section('meta')
    <title> @lang('home.thank you your order placed successfully')</title>
@endsection
@section('content')

@include('website.banner', [
    'bannerTitle' =>__('home.order_completed'),
])
<section class="page-404-wrap">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="image"> <img src="{{url('public/assets/front/images/thank.png.crdownload')}}" alt=""> </div>
                <div class="title"> @lang('home.for paying and purchasing from our site') </div>
                <p></p> <a href="{{LaravelLocalization::localizeUrl('products')}}"
                    class="tf-btn btn-sm radius-3 btn-fill btn-icon animate-hover-btn">@lang('home.Shop Now')</a>
            </div>
        </div>
    </div>
</section> <!-- /page-404 --> <!-- Footer -->
@endsection
@section('script')
<script>
window.dataLayer = window.dataLayer || [];

@if($order)
window.dataLayer.push({
    'event': 'purchase',
    'ecommerce': {
        'transaction_id': "{{ $order->id }}",
        'affiliation': 'alkhabir',
        'value': {{ $order->total_price }},
        'currency': "{{ __('home.EGP') }}",
        'shipping': {{ $order->shipping_fees }},
        'items': {!! json_encode($order->products->map(function ($item) {
            return [
                'item_id' => $item->product_id,
                'item_name' => $item->product_name,
                'price' => $item->product_net_price,
                'quantity' => $item->quantity
            ];
        })) !!}
    }
});
@endif

</script>
@endsection