@extends('layouts.app')
@section('meta')
    @php echo $metatags @endphp
    @php echo $schema @endphp
@endsection
@section('content')
    <div class="page-content">
    <!-- blog-detail -->
    @include('website.banner',['bannerTitle' =>  $service->title ])
    <section class="flat-spacing-4">
        <div class="tf-main-product section-image-zoom">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <div class="tf-product-media-wrap sticky-top">
                            <div class="thumbs-slider">
                                <div dir="ltr" class="swiper tf-product-media-thumbs other-image-zoom" data-direction="vertical">
                                    <div class="swiper-wrapper stagger-wrap">
                                        <!-- main -->
                                        <div class="swiper-slide stagger-item" data-color="main">
                                            <div class="item">
                                                <img class="lazyload" data-src="{{ $service->image_source}}" src="{{ $service->image_source}}" alt="img-product">
                                            </div>
                                        </div>
                                        @foreach ($service->images as $image )
                                            <div class="swiper-slide stagger-item" data-color="main">
                                                <div class="item">
                                                    <img class="lazyload" data-src="{{ $image->image_source}}" src="{{ $image->image_source}}" alt="img-product">
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                                <div dir="ltr" class="swiper tf-product-media-main" id="gallery-swiper-started">
                                    <div class="swiper-wrapper" >
                                        <!-- main -->
                                        <div class="swiper-slide" data-color="main">
                                            <a href="{{ $service->image_source}}" target="_blank" class="item" data-pswp-width="770px" data-pswp-height="1075px">
                                                <img class="tf-image-zoom lazyload" data-zoom="{{ $service->image_source}}" data-src="{{ $service->image_source}}" src="{{ $service->image_source}}" alt="">
                                            </a>
                                        </div>
                                        @foreach ($service->images as $image )
                                            <div class="swiper-slide" data-color="main">
                                                <a href="{{ $image->image_source}}" target="_blank" class="item" data-pswp-width="770px" data-pswp-height="1075px">
                                                    <img class="tf-image-zoom lazyload" data-zoom="{{ $image->image_source}}" data-src="{{ $image->image_source}}" src="{{ $image->image_source}}" alt="">
                                                </a>
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="swiper-button-next button-style-arrow thumbs-next"></div>
                                    <div class="swiper-button-prev button-style-arrow thumbs-prev"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="tf-product-info-wrap position-relative">
                            <div class="tf-zoom-main"></div>
                            <div class="tf-product-info-list other-image-zoom">
                                <div class="tf-product-info-title">
                                    <h5>{{ $service->name}}</h5>
                                </div>
                                <div class="tf-product-info-badges">
                                    <div class="badges">{{ $service->parent_name}}</div>
                                    <div class="product-status-content">
                                        <i class="icon-lightning"></i>
                                        <p class="fw-6"> {!! $service->text !!} </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /default -->

    <!-- recent -->
    <section class="flat-spacing-4 services">
        <div class="container">
            <div class="flat-title">
                <span class="title">@lang('home.related_services')</span>
            </div>
            <div class="hover-sw-nav hover-sw-2">
                <div dir="ltr" class="swiper tf-sw-recent wrap-sw-over" data-preview="3" data-tablet="2" data-mobile="2" data-space-lg="30" data-space-md="30" data-space="15" data-pagination="1" data-pagination-md="1" data-pagination-lg="1">
                    <div class="swiper-wrapper">
                        @foreach ($relatedServices as $relatedService  )
                            <div class="swiper-slide" lazy="true">
                                <!-- card product 1 -->
                                <div class="card-product">
                                    <div class="card-product-wrapper">
                                        <a href="product-detail.html" class="product-img">
                                        <img class="lazyload img-product" data-src="{{ $relatedService->image_source}}" src="{{ $relatedService->image_source}}" alt="image-product">
                                            <img class="lazyload img-hover" data-src="{{ $relatedService->image_source}}" src="{{ $relatedService->image_source}}" alt="image-product">
                                        </a>
                                    </div>
                                    <div class="card-product-info">
                                        <a href="#" class="title link">{{ $relatedService->name}}</a>
                                        <p>{{ $relatedService->text}}</p>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                <div class="nav-sw nav-next-slider nav-next-recent box-icon w_46 round"><span class="icon icon-arrow-left"></span></div>
                <div class="nav-sw nav-prev-slider nav-prev-recent box-icon w_46 round"><span class="icon icon-arrow-right"></span></div>
                <div class="sw-dots style-2 sw-pagination-recent justify-content-center"></div>
            </div>
        </div>
    </section>
@endsection
@section('script')
@endsection
