<script>
    $(function(){
        $(document).on('change','.get-areas', function () {
            let region_id = $(this).val() ;
            getArea(region_id ,function(response) {
                if(response.status){
                    $('#area-container').html(response.html)
                }
            })
        })

        $(document).on('change','.get-areas-edit', function () {
            let region_id = $(this).val() ;
            let element = $(this) ;

            getArea(region_id ,function(response) {
                if(response.status){
                    element.closest('.edit-form-address').find('.area-container').html(response.html)
                }
            })
        })
    })

    function getArea(region_id ,callback){
        $.ajax({
            url: "{{LaravelLocalization::localizeUrl('addresses/get-areas')}}",
            method: 'GEt',
            data: {'region_id': region_id},
            success: function(response){
                callback({
                    'status': true ,
                    'html': response.html,
                })
            },
            error: function (xhr, status, error) {
                callback({
                    'status': false ,
                })
                errorMessage(xhr, status, error)
            }

        })
    }
</script>