@extends('layouts.app')
@section('meta')
    @php echo $metatags @endphp
    @php echo $schema @endphp
@endsection
@section('content')
    <div class="page-content">
        @include('website.product.banner' ,['product' => $productInfo])
        @include('website.product.product-info',['product' => $productInfo])
        @include('website.product.tabs',['product' => $productInfo])
        @include('website.product.related',['product' => $productInfo])
    </div>
@endsection

@section('script')

    <script>
        window.dataLayer = window.dataLayer || [];
        window.dataLayer.push({
            'event': 'view_item',
            'ecommerce': {
                'currency': "{{ __('home.EGP') }}",
                'value': {{ $productInfo->net_price }},
                'items': [{
                    'item_id': "{{ $productInfo->id }}",
                    'item_name': "{{ $productInfo->name }}",
                    'category': "{{ $productInfo->category_name ?? '' }}",
                    'price': {{ $productInfo->net_price }},
                    'quantity': 1
                }]
            }
        });
    </script>

@endsection
