@if(!$blogsHeader->isEmpty())
    <!-- blog-grid-main -->
    <div class="blog-grid-main">
        <div class="container">
            <div class="flat-title flex-row justify-content-between px-0">
                <span class="title wow fadeInUp text_green-1" data-wow-delay="0s">@lang('home.blogs')</span>
            </div>
            <div class="row">
                @foreach ($blogs ?? $blogsHeader->take(3) as $blog )
                    <div class="col-xl-4 col-md-6 col-12">
                        <div class="blog-article-item">
                            <div class="article-thumb">
                                <a href="{{LaravelLocalization::localizeUrl('blog/'.$blog->link)}}">
                                    <img class="lazyload" data-src="{{$blog->image_source}}" src="{{$blog->image_source}}" alt="img-blog">
                                </a>
                                <div class="article-label">
                                    <a href="{{LaravelLocalization::localizeUrl('blog/'.$blog->link)}}" class="tf-btn btn-sm radius-3 btn-fill animate-hover-btn">{{$blog->title}}</a>
                                </div>
                            </div>
                            <div class="article-content">
                                <div class="article-title">
                                    <a href="{{LaravelLocalization::localizeUrl('blog/'.$blog->link)}}" class="">{{Helper::removeTagsAndCutText($about->text,50) }}.</a>
                                </div>
                                <div class="article-btn">
                                    <a href="{{LaravelLocalization::localizeUrl('blog/'.$blog->link)}}" class="tf-btn btn-line fw-6">@lang('home.more_details')<i class="icon icon-arrow1-top-left"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="more-btn text-center">
                <a href="{{LaravelLocalization::localizeUrl('blogs')}}" class="tf-btn btn-sm radius-3 btn-fill btn-icon animate-hover-btn mt-5 hover-icon"><span>@lang('home.blogs')
                    </span><i class="icon icon-arrow1-top-left"></i></a>
            </div>
        </div>
    </div>
    <!-- /blog-grid-main -->
@endif



<!-- /blog-grid-main -->