@extends('layouts.app')
@section('meta')
    @php echo $metatags @endphp

    @php echo $schema @endphp
@endsection
@section('content')


@include('website.banner',['bannerTitle' => __('home.contact_us') ])


        <!-- /page-title -->
        <!-- map -->
        <section class="flat-spacing-9">
            <div class="container">
                <div class="tf-grid-layout gap-0 lg-col-2">
                    <div class="w-100">
                        <iframe src="{{config('site_map_url')}}" width="100%" height="500" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                    <div class="tf-content-left has-mt">
                        <div class="sticky-top">
                            <h5 class="mb_20">@lang('home.contact_information')</h5>
                            <div class="mb_20">
                                <p class="mb_15"><strong>@lang('home.address')</strong></p>
                                <p>{{config('site_address1')}}</p>
                                 <p>{{config('site_address2')}}</p>
                            </div>
                            <div class="mb_20">
                                <p class="mb_15"><strong>@lang('home.phone')</strong></p>
                                <a href="tel:+2{{config('site_mobile')}}"><p>{{config('site_mobile')}}</p></a>
                            </div>
                            <div class="mb_20">
                                <p class="mb_15"><strong>Email</strong></p>
                                <a href="mailto:{{config('site_email')}}"><p>{{config('site_email')}}</p></a>
                            </div>
                            <div>
                                <ul class="tf-social-icon d-flex gap-20 style-default">

                                    @if (config('site_facebook'))
                                        <li><a href="{{config('site_facebook')}}" class="box-icon link round social-facebook border-line-black"><i class="icon fs-14 icon-fb"></i></a></li>
                                    @endif
                                    @if (config('site_twitter'))
                                        <li><a href="{{config('site_twitter')}}" class="box-icon link round social-twiter border-line-black"><i class="fab fa-twitter fs-12"></i></a></li>
                                    @endif
                                    @if (config('site_instagram'))
                                        <li><a href="{{config('site_instagram')}}" class="box-icon link round social-instagram border-line-black"><i class="icon fs-14 icon-instagram"></i></a></li>
                                    @endif

                                    @if (config('site_tiktok'))
                                        <li><a href="{{config('site_tiktok')}}" class="box-icon link round social-tiktok border-line-black"><i class="icon fs-14 icon-tiktok"></i></a></li>
                                    @endif

                                    @if (config('site_pinterest'))
                                        <li><a href="{{config('site_pinterest')}}" class="box-icon link round social-pinterest border-line-black"><i class="icon fs-14 icon-pinterest-1"></i></a></li>
                                     @endif

                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- /map -->
        <!-- form -->
        <section class="bg_grey-7 flat-spacing-9">
            <div class="container">
                <div class="flat-title">
                    <span class="title">@lang('home.contactUs')</span>
                    {{-- <p class="sub-title text_black-2">If you’ve got great products your making or looking to work with us then drop us a line.</p> --}}
                </div>
                <div>
                    <form  class="mw-705 mx-auto text-center form-contact" id="contactSubmit" action="LaravelLocalization::localizeUrl('save/contact-us')" method="post">
                        <div class="d-flex gap-15 mb_15">
                            <fieldset class="w-100">
                                <input type="text" name="name" id="name"  placeholder="@lang('home.name') *"/>
                            </fieldset>
                            <fieldset class="w-100">
                                <input type="text" name="phone" id="phone"  placeholder="@lang('home.phone') *"/>
                            </fieldset>
                        </div>
                        <div class="d-flex gap-15 mb_15">
                            <fieldset class="w-100">
                                <input type="email" name="email" id="email"  placeholder="@lang('home.email') *"/>
                            </fieldset>
                        </div>
                        <div class="mb_15">
                            <textarea placeholder="Message" name="message" id="message"  cols="30" rows="10"></textarea>
                        </div>
                        @csrf
                        <div class="send-wrap">
                            <button type="submit" class="tf-btn radius-3 btn-fill animate-hover-btn justify-content-center">Send</button>
                        </div>
                    </form>
                </div>
            </div>
        </section>
        <!-- /form -->
        <!-- Footer -->
@endsection

@section('script')
@include('website.scripts.show-message', [
  'formName' => '#contactSubmit',
  'urlForm' => LaravelLocalization::localizeUrl('save/contact-us'),
])

@endsection
