@extends('layouts.app')
@section('meta')
    <title>{{__('home.not_found')}}</title>
@endsection
@section('content')
     <!-- page-title -->
     <div class="tf-page-title style-2">
        <div class="container-full">
            <div class="heading text-center">@lang('home.error') 404</div>
        </div>
    </div>
    <!-- /page-title -->

    <!-- page-404 -->
    <section class="page-404-wrap">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="image">
                        <img src="{{url('public/assets/front/images/icon/404.svg')}}" alt="">
                    </div>
                    <div class="title">
                       @lang('home.Oops...That link is broken')
                    </div>
                    <p>@lang('home.Sorry for the inconvenience. Go to our homepage to check out our latest collections')</p>
                    <a href="{{ LaravelLocalization::localizeUrl('products') }}" class="tf-btn btn-sm radius-3 btn-fill btn-icon animate-hover-btn">@lang('home.shop_now')</a>
                </div>
            </div>
        </div>
    </section>
    <!-- /page-404 -->
@endsection