
@extends('layouts.app')
@section('meta')
    <title> @lang('home.login')</title>
@endsection
@section('content')
@include('website.banner' ,[ 'bannerTitle' => __('home.register') ])
<section class="flat-spacing-10">
    <div class="container">
        <div class="form-register-wrap">
            <div class="flat-title align-items-start gap-0 mb_30 px-0">
                <h5 class="mb_18">@lang('home.register')</h5>
                <p class="text_black-2">@lang('home.Sign up for early Sale access plus tailored new arrivals, trends and promotions. To opt out, click unsubscribe in our emails')</p>
            </div>
            <div>
                <form class="" id="register-form"  action="{{ route('register') }}" method="post" accept-charset="utf-8" data-mailchimp="true">
                    <div class="tf-field style-1 mb_15">
                        <input class="tf-field-input tf-input" placeholder=" " type="text" id="property1" @old('f_name')  name="f_name">
                        <label class="tf-field-label fw-4 text_black-2" for="property1">@lang('home.f_name')</label>
                    </div>
                    <div class="tf-field style-1 mb_15">
                        <input class="tf-field-input tf-input" placeholder=" " type="text" @old('l_name') id="property2" name="l_name">
                        <label class="tf-field-label fw-4 text_black-2" for="property2">@lang('home.l_name')</label>
                    </div>
                    <div class="tf-field style-1 mb_15">
                        <input class="tf-field-input tf-input" placeholder="@lang('home.email')" type="email" @old('email') id="property3" name="email">
                        <label class="tf-field-label fw-4 text_black-2" for="property3">@lang('home.email') *</label>
                    </div>
                    <div class="tf-field style-1 mb_15">
                        <input class="tf-field-input tf-input" placeholder="@lang('home.phone')" type="email" @old('phone') id="property4" name="phone">
                        <label class="tf-field-label fw-4 text_black-2" for="property3">@lang('home.phone') *</label>
                    </div>
                    <div class="tf-field style-1 mb_30">
                        <input class="tf-field-input tf-input" placeholder="@lang('home.password')" type="password" id="property5" name="password">
                        <label class="tf-field-label fw-4 text_black-2" for="property4">@lang('home.password') *</label>
                    </div>

                    <div class="tf-field style-1">
                        <input class="tf-field-input tf-input" placeholder="@lang('home.confirm_password')" type="password" id="property7"  name="password_confirmation">
                        <label class="tf-field-label" for="">@lang('home.confirm_password') *</label>
                    </div>
                    <div class="mb_20">
                        <button type="submit" class="tf-btn w-100 radius-3 btn-fill animate-hover-btn justify-content-center">@lang('home.register')</button>
                    </div>
                    <div class="text-center">
                        <a href="{{ url('login') }}" class="tf-btn btn-line">@lang('home.Already have an account?')<i class="icon icon-arrow1-top-left"></i></a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
@endsection

@section('script')

@endsection
