@extends('layouts.admin')
<title>{{ trans('home.add_vendor') }}</title>
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.vendors') }}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">{{ trans('home.admin') }}</a></li>
                <li class="breadcrumb-item"><a href="{{ url('admin/vendors') }}">{{ trans('home.vendors') }}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{ trans('home.add_vendor') }}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Row -->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1">{{ trans('home.add_vendor') }}</h6>
                    </div>

                    {!! Form::open(['route' => 'vendors.store', 'files' => true]) !!}
                    <div class="row">

                        <div class="form-group col-md-6">
                            <label>{{ trans('home.name_ar') }}</label>
                            <input class="form-control" name="name_ar" type="text" placeholder="{{ trans('home.name_ar') }}" value="{{ old('name_ar') }}">
                        </div>

                        <div class="form-group col-md-6">
                            <label>{{ trans('home.name_en') }}</label>
                            <input class="form-control" name="name_en" type="text" placeholder="{{ trans('home.name_en') }}" value="{{ old('name_en') }}">
                        </div>

                        <div class="form-group col-md-4">
                            <label>{{ trans('home.country') }}</label>
                            <select class="form-control get-regions" name="country_id">
                                <option value="">{{ trans('home.choose') }}</option>
                                @foreach($countries as $country)
                                    <option value="{{ $country->id }}">{{ $country->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group col-md-4">
                            <label>{{ trans('home.region') }}</label>
                            <div id="region-container" class="">
                                <select class="form-control get-areas" name="region_id">
                                    <option value="">{{ trans('home.choose') }}</option>
                                    {{-- Fill with regions dynamically --}}
                                </select>
                            </div>

                        </div>

                        <div class="form-group col-md-4">
                            <label>{{ trans('home.area') }}</label>
                                <div id="area-container" class="">
                                    <select class="form-control" name="area_id">
                                        <option value="">{{ trans('home.choose') }}</option>
                                {{-- Fill with areas dynamically --}}
                                    </select>
                            </div>
                        </div>

                        <div class="form-group col-md-12">
                            <label>{{ trans('home.address') }}</label>
                            <input class="form-control" name="address" type="text" placeholder="{{ trans('home.address') }}" value="{{ old('address') }}">
                        </div>

                        <div class="form-group col-md-6">
                            <label>{{ trans('home.phone') }}</label>
                            <input class="form-control" name="phone" type="text" placeholder="{{ trans('home.phone') }}" value="{{ old('phone') }}">
                        </div>

                        <div class="form-group col-md-6">
                            <label>{{ trans('home.logo') }}</label>
                            <div class="input-group mb-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">{{ trans('home.upload') }}</span>
                                </div>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" name="logo">
                                    <label class="custom-file-label">{{ trans('home.choose_logo') }}</label>
                                </div>
                            </div>
                        </div>

                        <div class="form-group col-md-12">
                            <label class="ckbox">
                                <input name="status" value="1" type="checkbox" {{ old('status', 1) ? 'checked' : '' }}>
                                <span class="tx-13">{{ trans('home.publish') }}</span>
                            </label>
                        </div>

                        <div class="form-group col-md-12">
                            <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{ trans('home.save') }}</button>
                            <a href="{{ url('/admin/vendors') }}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{ trans('home.cancel') }}</button></a>
                        </div>

                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
</div>

@endsection
@section('script')
@include('website.scripts.checkout.get-regions')
@include('website.scripts.checkout.get-areas')

@endsection