@extends('layouts.admin')
<title>{{trans('home.sale requests')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.sale requests')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.sale requests')}}</li>
                </ol>
            </div>

            <div class="btn btn-list">
                <a id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> {{trans('home.delete')}}</button></a>
            </div>
        </div>
        <!-- End Page Header -->



        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.sale requests')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                        </div>

                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll"/></th>
                                    <th>{{trans('home.id')}}</th>
                                    <th>{{trans('home.name')}}</th>
                                    <th>{{trans('home.email')}}</th>
                                    <th>{{trans('home.phone')}}</th>
                                     <th>{{trans('home.date')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($sale_requests as $sale_request)
                                    <tr id="{{$sale_request->id}}">
                                        <td class=" {{$sale_request->bg}}"><input type="checkbox" name="checkbox"  class="tableChecked" value="{{$sale_request->id}}" /> </td>
                                        <td class=" {{$sale_request->bg}}"><a href="{{ route('sale-requests.show', $sale_request->id) }}">{{$sale_request->id}}</a></td>
                                        <td class=" {{$sale_request->bg}}"><a href="{{ route('sale-requests.show', $sale_request->id) }}">{{$sale_request->name}}</a></td>
                                        <td class=" {{$sale_request->bg}}"><a href="{{ route('sale-requests.show', $sale_request->id) }}">{{$sale_request->email}}</a></td>
                                        <td class=" {{$sale_request->bg}}"><a href="{{ route('sale-requests.show', $sale_request->id) }}">{{$sale_request->phone}}</a></td>
                                        <td class=" {{$sale_request->bg}}"><a href="{{ route('sale-requests.show', $sale_request->id) }}">{{date_format($sale_request->created_at ,'Y-m-d')}}</a></td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
    </div>
@endsection
