@extends('layouts.admin')
<title>{{trans('home.products')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.products')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.products')}}</li>
                </ol>
            </div>

            <div class="btn btn-list">
                <a href="{{url('admin/products/create')}}"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> {{trans('home.add')}}</button></a>
                <a id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> {{trans('home.publish/unpublish')}}</button></a>
                <a id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> {{trans('home.delete')}}</button></a>
                <a href="{{url('/admin/products/download/export')}}" ><button class="btn ripple btn-success"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-explicit-fill" viewBox="0 0 16 16">
                    <path d="M2.5 0A2.5 2.5 0 0 0 0 2.5v11A2.5 2.5 0 0 0 2.5 16h11a2.5 2.5 0 0 0 2.5-2.5v-11A2.5 2.5 0 0 0 13.5 0zm4.326 10.88H10.5V12h-5V4.002h5v1.12H6.826V7.4h3.457v1.073H6.826z"/>
                  </svg> {{trans('home.export')}}</button>
                </a>
                <form action="{{ url('/admin/products/upload/import') }}" method="POST" id="importForm" enctype="multipart/form-data" hidden>
                    @csrf
                    <input type="file" name="excel" id="excelInput" onchange="document.getElementById('importForm').submit()" hidden>
                </form>

                <a href="javascript:void(0)" onclick="document.getElementById('excelInput').click()">
                    <button class="btn ripple btn-warning">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-cloud-upload-fill" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M8 0a5.53 5.53 0 0 0-3.594 1.342c-.766.66-1.321 1.52-1.464 2.383C1.266 4.095 0 5.555 0 7.318 0 9.366 1.708 11 3.781 11H7.5V5.707L5.354 7.854a.5.5 0 1 1-.708-.708l3-3a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1-.708.708L8.5 5.707V11h4.188C14.502 11 16 9.57 16 7.773c0-1.636-1.242-2.969-2.834-3.194C12.923 1.999 10.69 0 8 0m-.5 14.5V11h1v3.5a.5.5 0 0 1-1 0"/>
                        </svg>
                        {{ trans('home.import') }}
                    </button>
                </a>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.products')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                        </div>

                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll"/></th>
                                    <th>#</th>
                                    <th>{{trans('home.id')}}</th>
                                    <th class="wd-20p">{{trans('home.name_en')}}</th>
                                    <th class="wd-25p">{{trans('home.name_ar')}}</th>
                                    <th class="wd-20p">{{trans('home.image')}}</th>
                                    <th class="wd-20p">{{trans('home.category')}}</th>
                                    <th class="wd-20p">{{trans('home.brand')}}</th>
                                    <th class="wd-20p">{{trans('home.hot_offers')}}</th>
                                    <th class="wd-20p">{{trans('home.images')}}</th>
                                    <th class="wd-15p">{{trans('home.status')}}</th>
                                     @role('admin')
                                    <th class="wd-15p">{{trans('home.vendor')}}</th>
                                    <th class="wd-15p">{{trans('home.approved')}}</th>
                                    @endrole
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($products as $key=>$product)
                                    <tr id="{{$product->id}}">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$product->id}}" /> </td>
                                        <td><a href="{{ route('products.edit', $product->id) }}">{{$key+1}}</a></td>
                                        <td><a href="{{ route('products.edit', $product->id) }}">{{$product->id}}</a></td>
                                        <td><a href="{{ route('products.edit', $product->id) }}">{{$product->name_en}}</a></td>
                                        <td><a href="{{ route('products.edit', $product->id) }}">{{$product->name_ar}}</a></td>
                                        <td>
                                            <a href="{{ route('products.edit', $product->id) }}">
                                                <img style="border-radius:50%" src="{{$product->main_image_200}}"  alt="product-image" title="{{$product->name}}" width="50" height="50">
                                            </a>
                                        </td>
                                        <td><a href="{{ route('products.edit', $product->id) }}"> {{ $product->category_name ?? __('home.no category') }} </a></td>
                                        <td><a href="{{ route('products.edit', $product->id) }}"> {{ $product->brand_name ?? __('home.no brand') }} </a></td>
                                        <td>
                                            <a href="{{ route('discounts.index', $product->id) }}">
                                                @if($product->discount)
                                                    <span class="btn badge-success" style="min-width: 100%">{{trans('home.yes')}}</span>
                                                @else
                                                    <span class="btn badge-light" style="min-width: 100%">{{trans('home.no')}}</span>
                                                @endif
                                            </a>
                                        </td>
                                        <td><a href="{{ route('products.images.index', $product->id) }}">{{__('home.view')}} <br>({{$product->images()->count();}} {{__('home.image')}}) </a></td>
                                        <td>
                                            <a href="{{ route('products.edit', $product->id) }}" class="status">
                                                @if($product->status == 1)
                                                    <span class="btn badge-success" style="min-width: 100%">{{trans('home.yes')}}</span>
                                                @else
                                                    <span class="btn badge-danger" style="min-width: 100%">{{trans('home.no')}}</span>
                                                @endif
                                            </a>
                                        </td>
                                         @role('admin')
                                         <td>
                                            <a href="{{ route('products.edit', $product->id) }}" class="status">
                                                
                                                <span  style="min-width: 100%">{{$product->vendor_name}}</span>
                                              
                                            </a>
                                        </td>
                                         <td>
                                            @if($product->approved)
                                                <span class="status form-control badge badge-light" style="min-width: 100% ; align-content: center;">
                                                    {{ trans('home.approved') }}
                                                </span>
                                            @else
                                                <form action="{{ route('products.approved', $product->id) }}" method="POST" style="display:inline;">
                                                    @csrf
                                                    @method('PATCH')
                                                    <button type="submit" class="status btn btn-danger " style="min-width: 100%">
                                                        {{ trans('home.approve') }}
                                                    </button>
                                                </form>
                                            @endif
                                        </td>
                                        @endrole
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
					    </div>
                    </div>



                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
