@extends('layouts.admin')
@section('meta')
<title>{{trans('home.add_announcement')}}</title>
@endsecti
@section('content')

<div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.announcements')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item"><a href="{{url('admin/announcements')}}">{{trans('home.announcements')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_announcement')}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.add_announcement')}}</h6>
                        </div>
                        {!! Form::open(['route' => 'announcements.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
                            <div class="row">

                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.title_en')}}</label>
                                    <textarea class="form-control" name="title_en"  placeholder="{{trans('home.title_en')}}">{{ old('title_en') }}</textarea>
                                </div>

                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.title_ar')}}</label>
                                    <textarea class="form-control" name="title_ar"  placeholder="{{trans('home.title_ar')}}">{{ old('title_ar') }}</textarea>
                                </div>


                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="status" value="{{old('status') ?? 1}}" type="checkbox"><span class="tx-13">{{trans('home.publish')}}</span>
                                    </label>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                    <a href="{{url('/admin/announcements')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                </div>

                            </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

@endsection

