<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionsSeeder extends Seeder
{
    public function run()
    {
        // Permissions
        $permissions = [
            'menus',  'sliders',
            'about', 'editAbout', 'aboutStrucs', 'blogs',
             'categories', 'attributes', 'brands',
            'products', 'countries', 'regions', 'areas',  'pages',
            'coupons',  'orders', 'reports', 'seo',
            'settings',  'deliveries',
            'users', 'admins', 'roles', 'permissions', 'languages',
            'contact-us', 'shippingFees',
        ];

        foreach ($permissions as $permission) {
            Permission::create(['name' => $permission]);
        }

        // Admin Role
        $adminRole = Role::create(['name' => 'admin']);

        // Assign all permissions to admin
        $adminRole->givePermissionTo(Permission::all());
        User::find(1)->assignRole('admin') ;
    }
}
