<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('seo_assisatant', function (Blueprint $table) {
            $table->string('service_meta_title_en')->nullable();
            $table->text('service_meta_desc_en')->nullable();
            $table->string('service_meta_title_ar')->nullable();
            $table->text('service_meta_desc_ar')->nullable();
            $table->string('service_meta_robots')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('seo_assisatant', function (Blueprint $table) {
            $table->dropColumn([
                'service_meta_title_en',
                'service_meta_desc_en',
                'service_meta_title_ar',
                'service_meta_desc_ar',
                'service_meta_robots',
            ]);
        });
    }
};
