<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('testimonials', function (Blueprint $table) {
            $table->id();
            $table->string('name_en')->nullable();
            $table->string('name_ar')->nullable();
            $table->string('position')->nullable();
            $table->string('image')->nullable();
            $table->text('text_en')->nullable(); // Changed to `text`
            $table->text('text_ar')->nullable(); // Changed to `text`
            $table->boolean('status')->default(0);
            $table->timestamps();
        
            $table->index('status'); // Index for performance
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('testimonials');
    }
};
