<?php
namespace App\Traits\Carts;

use App\Models\Coupon;
use App\Models\GuestCart;
use Illuminate\Support\Str;


trait GuestCartTrait {

    private function getGuestCart(){
        $session = $this->getOrGenerateGuestCartSession();
        return  GuestCart::with(['items' ,'coupon']) ->firstOrCreate(['session_id' =>  $session ] );
    }

    private function getOrGenerateGuestCartSession(){
        if(session()->has('cart_session')){
            return session('cart_session') ;
        }

        session()->put('cart_session' , $this->generateUniqueName());
        return session('cart_session') ;
    }

    private function generateUniqueName(){
        return 'guest' . '-' . Str::uuid();
    }
}