<?php
namespace App\Traits\Carts;

use App\Models\Cart;
use App\Models\GuestCart;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

trait ConvertFromCartGuestToCartTraite
{

    public function guestOperations(){

        if(Session::has('cart_session') && auth()->check()){
            $session_id = Session::get('cart_session');
            $guestCart = GuestCart::where('session_id',$session_id)->first();
            if(!$guestCart){
                Session::forget('cart_session');
                return ;
            }
         

            $cartItems = $guestCart->items ;
            $guestCart->user_id = auth()->user()->id ; // Copy the value from old_key to new_key
            unset($guestCart->session_id);

            $authCart = Cart::with(['items' ,'coupon']) ->updateOrCreate(['user_id' =>   $guestCart->user_id ] , ['coupon_id' => $guestCart->coupon_id  ]) ;
            // map to remove Guest_cart_id form items ;
            $cartItems = $cartItems->map(function($item) use( $authCart){
                $item->cart_id =  $authCart->id ;
                unset($item->guest_cart_id);
                return $item->toArray() ;
            });
           
            foreach ($cartItems as $key => $item) {

               $authCart->items()->updateOrCreate(  ['product_stock_id' => $item['product_stock_id']] ,$item);
            }

            ////// delete guest cart////

            GuestCart::find($guestCart->id)->delete();
            Session::forget('cart_session');
        }
    }
}
