<?php

namespace App\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;
use Illuminate\Support\Facades\Request;
use ReflectionClass;

class ProductByRollScope implements Scope
{
    public function apply(Builder $builder, Model $model)
    {
        // Only apply if request is from /admin/*
        if (Request::segment(2) === 'admin') {
            if(auth()->user()->roles()->where('name', 'vendor')->exists()){
                $builder->where('vendor_id', auth()->user()->vendor_id);
            }
        }
    }



}
