<?php

namespace App\Providers;

use App\Models\About;
use App\Models\Announcement;
use App\Models\Blog;
use App\Models\Category;
use App\Models\Menu;
use App\Models\Page;
use App\Models\Brand;
use App\Models\Service;
use Illuminate\Support\Facades\URL;

use App\Traits\Carts\CartTrait;
use App\Traits\Carts\GuestCartTrait;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;

use Illuminate\Support\Facades\View;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class AppServiceProvider extends ServiceProvider
{

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register():void
    {
        //
    }


    public function boot()
    {
        /**
        *-------------------------------------------------------------------------------------*
        *                              important note                                         *
        *-------------------------------------------------------------------------------------*
        *                                                                                     *
        * 1- the cart var shared by middleware name it GetActiveCart                          *
        * 2 - the site config created by middleware name it GlobalConfigMiddleware            *
        *                                                                                     *
        *-------------------------------------------------------------------------------------*

        **/
    if (env('APP_ENV') === 'production') {
        URL::forceScheme('https');
    }


        Blade::directive('old', function ($expression) {
            return "<?php echo 'value=\"' . old($expression) . '\"'; ?>";
        });
        Schema::defaultStringLength(191);

        view()->composer('*', function($view){
            $lang = LaravelLocalization::getCurrentLocale();

            // check user if auth and return the right model ;
            $menus = Menu::main()->active()->orderBy('order')->get();
            $categories = Category::active()->mianCategory()->orderBy('order')->get();
            $brands = Brand::active()->orderBy('order')->get();
            $about = About::first();
            $blogsHeader = Blog::active()->take(5)->latest()->get() ;
            $servicesHeader = Service::active()->take(5)->latest()->get() ;
            $announcements = Announcement::active()->get();
            $pages = Page::get();
            View::share('lang', $lang);
            View::share('menus', $menus);
            View::share('categoriesHeader', $categories);
            View::share('brands', $brands);
            View::share('pages', $pages);
            View::share('about', $about);
            View::share('announcements', $announcements);
            View::share('pages', $pages);
            View::share('blogsHeader', $blogsHeader);
            View::share('servicesHeader', $servicesHeader);

            if( auth()->check() ){
                $wishlist = auth()->user()->wishlistItems ;
                View::share('wishlist', $wishlist);
            }
        });
    }
}
