<?php

namespace App\Models;

use App\Helpers\Helper;
use App\Helpers\SaveImageTo3Path;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Vendor extends Model
{
    use HasFactory;

        protected $fillable = [
        'name_ar',
        'name_en',
        'country_id',
        'region_id',
        'area_id',
        'address',
        'phone',
        'logo',
        'status',
    ];

    const IMAGE_FOLDER = 'vendors';
    private $lang ;

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        // Set the current locale dynamically
        $this->lang = Helper::getLang();
    }

    public function delete()
    {
        SaveImageTo3Path::deleteImage($this->logo,self::IMAGE_FOLDER);
        return parent::delete();
    }

    public function getNameAttribute(){
        return $this->{'name_'.$this->lang} ;
    }

     public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function region()
    {
        return $this->belongsTo(Region::class);
    }

    public function area()
    {
        return $this->belongsTo(Area::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }


    public function getRegionNameAttribute(){
        return $this->region?->{'name_'.$this->lang} ;
    }

    public function getLogo200Attribute(){
        return Helper::imageIsExists($this->logo ,self::IMAGE_FOLDER) ? Helper::uploadedImages200Path(self::IMAGE_FOLDER,$this->logo)  : Helper::noImageUser() ;
    }

    public function getLogoSourceAttribute(){

        return Helper::imageIsExists($this->logo ,self::IMAGE_FOLDER) ? Helper::uploadedImagesPath(self::IMAGE_FOLDER,$this->logo)  : Helper::noImageUser() ;
    }
    public function getCountryNameAttribute(){
        return $this->country?->{'name_'.$this->lang} ;
    }
    public function getAreaNameAttribute(){
        return $this->area?->{'name_'.$this->lang} ;
    }

    public function getFullAddressAttribute(){
        return $this->country_name .' - ' .$this->region_name .' - ' .  $this->area_name .' - ' .$this->address  ;
    }
}
