<?php

namespace App\Models;

use App\Helpers\Helper;
use App\Helpers\SaveImageTo3Path;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Traits\HasRoles;
use Tymon\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject
{
    use HasRoles;
    use Notifiable;

    protected $table='users';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'f_name',
        'l_name',
        'phone',
        'email',
        'image',
        'them',
        'email_verified_at',
        'password',
        'is_admin',
        'admin_seen',
         'vendor_id'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];


    public function delete()
    {
        SaveImageTo3Path::deleteImage($this->image,'users');

        return parent::delete();
    }

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }
    public function getJWTCustomClaims()
    {
        return [];
    }

    public function couponUseds(){
        return $this->hasMany(CouponUsed::class) ;
    }


    public function addresses(){
        return $this->hasMany(Address::class) ;
    }

    public function wishlistItems(){
        return $this->hasMany(Wishlist::class) ;
    }

    public function getPrimaryAddressAttribute(){
        return $this->addresses()->where('is_primary', 1)->first() ?? $this->addresses()->first() ;
    }


    public function isAdmin(){
        return $this->is_admin;
    }

    public function isVendor()
    {
        return $this->roles()->where('name', 'vendor')->exists();
    }

    public function getNameAttribute(){
        return $this->f_name.' '.$this->l_name;
    }

    public function name(){
        return $this->f_name.' '.$this->l_name;
    }

    public function getImage200Attribute(){

        return Helper::imageIsExists($this->image ,'users') ? Helper::uploadedImages200Path('users',$this->image)  : Helper::noImageUser() ;
    }

    public function getImageSourceAttribute(){

        return Helper::imageIsExists($this->image ,'users') ? Helper::uploadedImagesPath('users',$this->image)  : Helper::noImageUser() ;
    }

    public function stockInWishlist($stock_id){

        return $this->wishlistItems()->where('product_stock_id' , $stock_id)->exists()  ;
    }

    public function orders(){

        return $this->hasMany(Order::class ) ;
    }

    public function canRate($product_id)
    {
        return DB::table('users as u')
            ->join('orders as o', 'o.user_id', '=', 'u.id') // Match users to orders
            ->join('order_products as op', 'op.order_id', '=', 'o.id') // Match orders to order products
            ->join('product_stock as ps', 'op.product_stock_id', '=', 'ps.id') // Match order products to product stock
            ->join('products as p', 'ps.product_id', '=', 'p.id') // Match stock to products
            ->where('ps.product_id', $product_id) // Check for the specific product
            ->where('u.id', $this->id) // Check for the specific user
            ->exists(); // Return true if a record exists
    }








}
