<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Helpers\Helper;


class Testimonial extends Model
{
    protected $fillable = ['name_en', 'name_ar', 'text_en', 'text_ar', 'position', 'status' ,'image' ];
    private $lang ;
    
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    
        // Set the current locale dynamically
        $this->lang = Helper::getLang();
    
    }

    public function delete()
    {
        SaveImageTo3Path::deleteImage($this->image,'sliders');
    
        return parent::delete();
    }
    public function getTitleAttribute(){
        return $this->{'name_'.$this->lang} ;
    }

    public function getTextAttribute(){
        return $this->{'text_'.$this->lang} ;
    }

    public function getImageSourceAttribute(){
        return  Helper::imageIsExists($this->image ,'testimonials') ? Helper::uploadedImagesPath('testimonials',$this->image) : Helper::noImage() ;
    }

    public function getImage200Attribute(){
        return Helper::imageIsExists($this->image ,'testimonials') ? Helper::uploadedImages200Path('testimonials',$this->image) : Helper::noImage() ;
    }
    
    
}
