<?php

namespace App\Models;

use App\Helpers\Helper;
use App\Helpers\SaveImageTo3Path;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;

    private $lang ;

    public function delete()
    {

        SaveImageTo3Path::deleteImage($this->image,'services');
        SaveImageTo3Path::deleteImage($this->icon,'services');
        return parent::delete();
    }
    protected $fillable = [
        'parent_id',
        'name_ar',
        'name_en',
        'order',
        'text_ar',
        'text_en',
        'image',
        'icon',
        'status',
        'link_ar',
        'link_en',
        'mete_title_ar',
        'mete_title_en',
        'mete_description_ar',
        'mete_description_en',
        'index',
    ];


    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        // Set the current locale dynamically
        $this->lang = Helper::getLang();

    }

    public function children(){
        return $this->hasMany(self::class,'parent_id','id');
    }

    public function images(){
        return $this->morphMany(Image::class,'imageable');
    }


    public function parent(){
        return $this->belongsTo(self::class,'parent_id','id');
    }

    public function getNameAttribute(){
        return $this->{'name_'.$this->lang} ;
    }

    public function getTextAttribute(){
        return $this->{'text_'.$this->lang} ;
    }

    public function getLinkAttribute(){
        return $this->{'link_'.$this->lang} ;
    }


    public function getParentNameAttribute(){
        return  $this->parent?->name ?? trans('home.main_service');
    }

    public function getParentTextAttribute(){
        return $this->parent?->text ;

    }

    public function getParentLinkAttribute(){
        return  $this->parent?->link  ;
    }

    public function getImageSourceAttribute($value){

        return Helper::imageIsExists($this->image ,'services') ?  Helper::uploadedImagesPath('services',$this->image)   : Helper::noImage() ;

    }

    public function getImage200Attribute($value){

        return Helper::imageIsExists($this->image ,'services') ?  Helper::uploadedImages200Path('services',$this->image)  : Helper::noImage();

    }

    public function getIconSourceAttribute(){

        return Helper::imageIsExists($this->icon ,'services') ? Helper::uploadedImagesPath('services',$this->icon) : Helper::noImage();
    }

    public function getIcon200Attribute(){

        return Helper::imageIsExists($this->icon ,'services') ?Helper::uploadedImages200Path('services',$this->icon) : Helper::noImage();
    }

    public function getActiveAttribute(){
        return $this->status ? __('home.yes') : __( 'home.no') ;
     }

     public function scopeActive($query){
        return $query->whereStatus(1);
      }

    public function scopeUnactive($query){
        return $query->whereStatus(0);
    }

}
