<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Model;
use DB;


class Region extends Model
{
    //
    protected $table='regions';

    private $lang ;
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        // Set the current locale dynamically
        $this->lang = Helper::getLang();

    }



    public function country(){
        return $this->belongsTo('App\Models\Country','country_id');
    }

    public function addresses(){
        return $this->hasMany('App\Models\Address','region_id');
    }

    public function areas(){
        return $this->hasMany('App\Models\Area');
    }


    function scopeCheckBeforDelete($query){
        return $query->whereHas('addresses')
        ->orWhereHas('areas');
    }

    public function getNameAttribute(){
        return $this->{'name_'.$this->lang};
    }


    public function scopeByCountry($query ,$country_id){
        return $query->where('country_id', $country_id);
    }

    public function scopeByCountryAuth($query){
        return $query->where('country_id', auth()?->user()?->primary_address?->country_id);
    }
}
