<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use function PHPUnit\Framework\isEmpty;

class ProductStock extends Model
{
    use HasFactory;
    protected $table = 'product_stock';
    protected $fillable = [
        'product_id',
        'stock',
        'price',
    ];



    public function product(){
        return $this->belongsTo(Product::class);
    }

    public function values(){
        return $this->hasMany(ProductVariant::class , '');
    }


    public function valueInSameProduct($value_id , int $product_id){
        $stocks = Self::whereHas('values',function($q) use($value_id){
            $this->where('product_attribute_value_id' , $value_id);
        })->where('product_id' , $product_id)->get();
    }


    public function orders(){
        return $this->hasMany(OrderProduct::class);
    }

    public function getProductNameAttribute(){
        return $this->product?->name;
    }


    public function getProductLinkAttribute(){
        return $this->product?->link;
    }

    public function getProductMainImageAttribute(){
        return $this->product?->main_image_source;
    }

    public function getProductCategoryNameAttribute(){
        return $this->product?->category_name  ;
    }

    public function getProductCategoryIdAttribute(){
        return $this->product?->category_id  ;
    }
    public function getProductDiscountAmountAttribute(){

        if($this->product?->discount){
            if(!$this->product?->discount_type){
                return round($this->product?->discount_value , 2);
            }
            return round($this->product?->discount_value * $this->price / 100 ,2);

        }

        return 0 ;
    }

    public function getProductDiscountPercentageAttribute(){
        if($this->product?->discount){
            if($this->product?->discount_type){
                return round($this->product?->discount_value , 2);
            }
            return round($this->product?->discount_value / $this->price * 100, 2);
        }

        return 0 ;

    }

    public function getProductDiscountIdAttribute(){
        return $this->product?->discount_id;
    }



    public function getNetPriceAttribute(){
        return round($this->price - $this->product_discount_amount , 2) ;
    }

    public function getCanEditOrDeleteAttribute(){
        return OrderProduct::where('product_stock_id', $this->id)->count() === 0;
   }


}
