<?php

namespace App\Models;
use App\Models\OrderProductOption;

use Illuminate\Database\Eloquent\Model;

class OrderProduct extends Model
{
    //
    protected $table = 'order_products';
    protected $fillable = ['product_stock_id','price','dicount_id','quantity','total','product_discount','order_id'];


    public function product(){
        return $this->belongsTo(ProductStock::class ,'product_stock_id');
    }
    public function order(){
        return $this->belongsTo('App\Models\Order');
    }

    public function getProductIdAttribute(){
        return $this->product?->product_id;
    }

    public function getProductNameAttribute(){
        return $this->product?->product_name;
    }

    public function getProductLinkAttribute(){
        return $this->product?->product_link;
    }

    public function getProductMainImageAttribute(){
        return $this->product?->product_main_image;
    }

    public function getProductNetPriceAttribute(){
        return $this->product?->net_price;
    }

    public function getProductTotalNetPriceAttribute(){
        return $this->product?->net_price ?? 0 * $this->quantity ?? 0;
    }

}
