<?php
namespace App\Mails;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrderConfirmedMail extends Mailable implements ShouldQueue
{
    use  SerializesModels, Queueable;

    public $order; // Order details

    public function __construct($order)
    {
        $this->order = $order;
    }

    public function build()
    {
        return $this->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'))
                    ->subject('Order Confirmation')
                    ->view('emails.order_confirmed')
                    ->with(['order' => $this->order]);
    }
}
