<?php

namespace App\Imports;

use App\Models\Product;
use App\Models\ProductStock;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;


class ProductImport implements ToCollection  ,WithHeadingRow, WithValidation
{


  public function collection(Collection $rows)
    {


        foreach ($rows as $row) {
            $data = [];
            foreach ($row as $key => $value) {
                $data[$key] = $value ;
            }

            $Product = Product::create($data);
            $data['product_id'] = $Product->id ;
            ProductStock::create($data) ;

        }


    }

 /**
     * Define validation rules
     */
    public function rules(): array
    {
        return [
             'name_ar' => 'required|string|max:255|unique:products,name_ar',
            'name_en' => 'required|string|max:255|unique:products,name_en',
            'code' => 'nullable|string|max:10|unique:products,code' ,
            'category_id' => 'required|exists:categories,id',
            'brand_id' => 'nullable|exists:brands,id',
            'order' => 'required|integer',
            'text_ar' => 'nullable|string',
            'text_en' => 'nullable|string',
            'short_text_ar' => 'nullable|string',
            'short_text_en' => 'nullable|string',
            'main_image' =>  'required|string|max:255' ,
            'second_image' => 'required|string|max:255' ,
            'icon' => 'nullable|string|max:255',
            'status' => 'nullable|in:0,1', // Validate as 0 or 1
            'link_ar' => 'required|string|max:255|unique:products,link_ar',
            'link_en' => 'required|string|max:255|unique:products,link_en',
            'mete_title_ar' => 'nullable|string|max:255',
            'mete_title_en' => 'nullable|string|max:255',
            'mete_description_ar' => 'nullable|string',
            'mete_description_en' => 'nullable|string',
            'index' => 'nullable|boolean',

        ];
    }

    /**
     * Customize validation messages (optional)
     */
    public function customValidationMessages()
    {
        return [
            
        ];
    }
}
