<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TestimonialRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return  true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $userId = $this->route('user');
        return [
            'name_ar'   => 'nullable|string|max:255|required_without_all:name_en,image',
            'name_en'   => 'nullable|string|max:255|required_without_all:name_ar,image',
            'image'     => 'nullable|image|max:2048|required_without_all:name_ar,name_en',
            'position'  => 'nullable|string|max:15',
            'text_ar'   => 'nullable|email|max:255|',
            'text_en'   => 'nullable|email|max:255|',  
            'status'   => 'nullable|boolean|',

        ];
    }
}
