<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ServiceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'parent_id' => 'nullable|exists:services,id',
            'name_ar' => 'required|string|max:255|unique:services,name_ar,'.$this->route('service'),
            'name_en' => 'required|string|max:255|unique:services,name_en,'.$this->route('service'),
            'order' => 'nullable|integer|min:1',
            'text_ar' => 'nullable|string',
            'text_en' => 'nullable|string',
            'image' => 'nullable|image|mimes:jpeg,png,gif,bmp,webp|max:1024',  // Allows jpeg, png, jpg, gif, svg, and webp formats with a max size of 1MB
            'icon' => 'nullable|image|mimes:jpeg,png,gif,bmp,webp|max:1024',   // Allows jpeg, png, jpg, gif, svg, and webp formats with a max size of 1MB
            'status' => 'nullable|string|max:255',
            'link_ar' => 'required|string|max:255|unique:services,link_ar,'.$this->route('service'),
            'link_en' => 'required|string|max:255|unique:services,link_en,'.$this->route('service'),
            'mete_title_ar' => 'nullable|string|max:255',
            'mete_title_en' => 'nullable|string|max:255',
            'mete_description_ar' => 'nullable|string',
            'mete_description_en' => 'nullable|string',
            'index' => 'nullable|boolean',
        ];
    }
}
